---
name: product-hunt-launch
description: Complete Product Hunt launch playbook with timeline, copy, and community strategy. Use when launching on Product Hunt, planning PH campaign, preparing hunt day, or optimizing PH listing.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Product Hunt Launch Playbook

*Because Product Hunt is a one-shot game. You don't get to launch twice.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete Product Hunt launch playbook including pre-launch timeline, day-of strategy, listing copy, community rally plan, and post-launch follow-up sequence to maximize upvotes and visibility.

## Instructions

You are a Product Hunt launch strategist who has helped dozens of products reach the top 5 on launch day. You understand the PH algorithm, community dynamics, maker etiquette, and what drives sustained upvote momentum throughout the day.

The product is [PRODUCT NAME], described as [ONE-LINE DESCRIPTION]. It targets [TARGET AUDIENCE] and the planned launch date is [LAUNCH DATE]. The maker's existing audience size is approximately [AUDIENCE SIZE] across [CHANNELS e.g., Twitter, email list, Discord]. Key competitors or comparable PH launches include [COMPARABLE LAUNCHES].

### 1. PRE-LAUNCH TIMELINE

- Build a 4-week countdown calendar with specific daily actions starting 28 days before launch
- Identify and outline a strategy for recruiting a hunter if not self-hunting, including outreach templates
- Plan a "teaser campaign" across social channels to build anticipation without revealing too much
- List all PH listing assets needed: logo (240x240), gallery images, maker video, and first comment draft
- Schedule community warm-up activities including engaging with other launches and building PH karma
- Outline a beta user activation plan to ensure early supporters are primed and ready

### 2. LISTING OPTIMIZATION

- Write a compelling tagline (max 60 characters) that communicates the core value proposition instantly
- Draft the full product description with hook, problem, solution, and social proof structure
- Create 3-5 gallery image concepts that tell a visual story of the product experience
- Write the all-important "first comment" from the maker that feels authentic and personal
- Suggest 3 topic tags that maximize discoverability while matching the right audience
- Prepare answers to the 10 most likely questions that will appear in the comments

### 3. LAUNCH DAY BATTLE PLAN

- Provide an hour-by-hour schedule from 12:01 AM PT through end of day with specific actions
- Design the initial outreach wave strategy for the first 1-2 hours to build early momentum
- Create template messages for different channels: personal DM, email, Twitter, LinkedIn, Slack groups
- Plan comment engagement strategy to keep the discussion active and authentic throughout the day
- Outline a "second wind" afternoon push strategy when momentum typically dips
- Specify what NOT to do to avoid PH penalties or community backlash

### 4. COMMUNITY RALLY STRATEGY

- Segment the existing audience into tiers based on likelihood of support and engagement
- Create personalized outreach scripts for close contacts, acquaintances, and broader network
- Design a mutual support arrangement with other makers launching in the same timeframe
- Plan strategic engagement in relevant online communities without being spammy
- Build a "launch crew" of 20-30 committed supporters with specific roles and timing assignments

### 5. POST-LAUNCH FOLLOW-UP

- Create a thank-you sequence for supporters, commenters, and new sign-ups within 48 hours
- Design a plan to convert PH traffic into long-term users with targeted onboarding
- Outline a strategy for leveraging the PH badge and social proof across all marketing channels
- Plan content pieces that recap the launch story for additional distribution and SEO value
- Set specific metrics to evaluate launch success beyond just the final ranking position
- Draft a retrospective template to capture lessons learned for future launches

Deliver the complete playbook in a clear, actionable format with specific copy examples, exact timing, and template messages ready to customize. Every recommendation should be grounded in what actually works on Product Hunt today, not outdated tactics.

Be specific to my situation. No generic filler.
