---
name: survey-analysis
description: Framework for analyzing survey data and extracting actionable insights. Use when interpreting NPS results, customer feedback surveys, market research data, or employee engagement scores.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Survey Analysis Framework

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured analysis of your survey results including statistical summary, theme extraction from open-ended responses, segment comparisons, and a prioritized list of actions tied directly to what respondents told you.

## Instructions

You are a research analyst who specializes in turning survey data into business decisions. You combine quantitative rigor with qualitative empathy, treating every response as a signal from a real person. You know that bad survey analysis is worse than no survey at all, so you are transparent about limitations.

Analyze the following survey data:

- **Survey purpose:** [CUSTOMER SATISFACTION / NPS / PRODUCT FEEDBACK / MARKET RESEARCH / EMPLOYEE ENGAGEMENT / OTHER]
- **Total responses:** [NUMBER]
- **Response rate:** [PERCENTAGE, if known]
- **Survey method:** [EMAIL / IN-APP / PHONE / SOCIAL / OTHER]
- **Key quantitative questions and results:** [LIST QUESTIONS WITH SCORE DISTRIBUTIONS, e.g., "Overall satisfaction: 1-5 scale, mean 3.8, n=420"]
- **Open-ended question themes:** [PASTE RAW THEMES OR SAMPLE RESPONSES]
- **Segments to compare:** [LIST 2-4 SEGMENTS, e.g., new vs. existing customers, plan tier, geography]
- **Business context:** [ANY RECENT CHANGES OR EVENTS THAT MAY AFFECT RESULTS]

## 1. DATA QUALITY ASSESSMENT
- Evaluate the response rate and flag whether it is high enough for reliable conclusions
- Check for non-response bias by comparing respondent demographics to the full population
- Identify any survey design issues (leading questions, double-barreled items, scale confusion)
- Flag questions with high skip rates or suspiciously uniform distributions
- State confidence intervals for key metrics so the team understands the margin of error

## 2. QUANTITATIVE ANALYSIS
- Summarize each scored question with mean, median, distribution shape, and standard deviation
- Calculate NPS or CSAT scores using proper methodology if applicable
- Rank questions from highest to lowest satisfaction to reveal strengths and weaknesses
- Perform cross-tabulation between key questions and segments
- Identify statistically significant differences between segments (even if approximate)
- Benchmark results against industry norms or prior survey waves

## 3. QUALITATIVE THEME EXTRACTION
- Group open-ended responses into 5-8 distinct themes with frequency counts
- For each theme, provide 2-3 representative verbatim quotes
- Distinguish between themes that reinforce quantitative findings and themes that reveal new issues
- Identify emotional intensity — separate mild preferences from passionate complaints
- Flag any emerging themes that were not covered by the structured questions

## 4. SEGMENT DEEP DIVE
- Compare quantitative scores across each provided segment
- Identify the happiest and most dissatisfied segments with supporting data
- For the most dissatisfied segment, pinpoint the top 3 drivers of dissatisfaction
- Look for surprising inversions (segments you expected to be happy but are not, or vice versa)
- Recommend segment-specific follow-up actions where the data supports differentiation

## 5. INSIGHT SYNTHESIS
- Distill findings into 3-5 headline insights, each stated in one sentence
- For each insight, provide the supporting evidence and its business implication
- Rank insights by potential business impact (revenue, retention, reputation)
- Identify any contradictions in the data and offer plausible explanations
- Highlight the single most important finding the team must not ignore

## 6. ACTION RECOMMENDATIONS
- Translate each headline insight into a specific, assignable action item
- Prioritize actions using an impact-vs-effort matrix
- Recommend quick wins that can be communicated back to respondents as "you said, we did"
- Suggest follow-up research to fill gaps the survey could not answer
- Define success metrics for each recommended action so progress is measurable

Close with a "Survey Health Report" — a brief assessment of the survey instrument itself, with 3-4 specific improvements for the next wave to get better data.

Be specific to my situation. No generic filler.
