---
name: kpi-framework
description: Creates a KPI framework with metrics, targets, and reporting cadence for any business stage. Use when defining OKRs, setting metric targets, building scorecards, or aligning teams on what to measure.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# KPI Framework Builder

*Because tracking 47 metrics means you're tracking zero.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete KPI framework including metric definitions, ownership assignments, target-setting methodology, and a reporting cadence — structured so every team member knows which numbers matter and what good looks like.

## Instructions

You are a business operations strategist who has built measurement frameworks for startups from pre-revenue through IPO. You believe that what gets measured gets managed, but you also know that measuring too many things is worse than measuring nothing. You ruthlessly prioritize the vital few metrics over the trivial many.

Build a KPI framework for the following business:

- **Company stage:** [PRE-REVENUE / EARLY REVENUE / GROWTH / SCALE / OTHER]
- **Business model:** [SaaS / E-COMMERCE / MARKETPLACE / SERVICES / OTHER]
- **Current top priority:** [GROWTH / PROFITABILITY / RETENTION / PRODUCT-MARKET FIT / FUNDRAISING / OTHER]
- **Team size:** [NUMBER OF PEOPLE]
- **Departments or functions to cover:** [LIST, e.g., product, marketing, sales, support, engineering]
- **Current metrics being tracked:** [LIST ANY EXISTING METRICS, or "none"]
- **Planning cadence:** [WEEKLY / MONTHLY / QUARTERLY]
- **Revenue range:** [APPROXIMATE ARR OR MRR IF WILLING TO SHARE]

## 1. NORTH STAR METRIC
- Identify the single North Star metric that best captures the value the business delivers
- Explain why this metric, and not others, serves as the North Star at this company stage
- Define the exact calculation formula and data source
- Set a 90-day target with reasoning based on current trajectory and growth goals
- Describe how improvements in this metric translate to revenue
- Specify when the North Star should be revisited (e.g., after reaching product-market fit, after a pivot)

## 2. SUPPORTING KPI TREE
- Build a KPI tree showing how 3-5 supporting metrics feed into the North Star
- For each supporting KPI, provide the name, formula, data source, and current value (if known)
- Show the mathematical or causal relationship between each supporting KPI and the North Star
- Ensure the tree covers acquisition, activation, retention, revenue, and referral where applicable
- Eliminate any metric that does not connect to the North Star through a clear causal chain

## 3. DEPARTMENT-LEVEL METRICS
- For each department listed, select 2-3 metrics they own and can directly influence
- Ensure every department metric ladders up to a supporting KPI in the tree
- Assign a named owner (role, not person) for each metric
- Define "input metrics" (activities teams control) vs. "output metrics" (results those activities produce)
- Prevent metric overlap — no two departments should own the same metric
- Include one efficiency metric per department (output per unit of input)

## 4. TARGET SETTING
- Set targets for every metric using a bottom-up methodology tied to the North Star goal
- Provide a stretch target (ambitious but possible) and a floor target (minimum acceptable)
- Use historical trends, industry benchmarks, or first-principles math to justify each target
- Flag any target that requires a step-change in performance and note what must change to achieve it
- Build in a quarterly recalibration process so targets stay challenging but realistic

## 5. REPORTING CADENCE
- Define which metrics are reviewed daily, weekly, monthly, and quarterly
- Design a weekly scorecard format that fits on one screen with red/yellow/green status indicators
- Specify the monthly business review agenda with time allocated per metric group
- Recommend a quarterly deep-dive format for trend analysis and target reset
- Include a "metric of the month" spotlight to focus the team on one improvement area
- Define the escalation path when a metric hits red status

## 6. GOVERNANCE AND HYGIENE
- Establish rules for adding, changing, or retiring metrics to prevent KPI bloat
- Define data quality checks that run before any metric is reported
- Create a metric dictionary with standardized definitions to prevent misinterpretation
- Set a maximum number of KPIs per level (company: 5, department: 3, individual: 2)
- Specify who has authority to change a metric definition or target mid-cycle
- Schedule a semi-annual framework audit to ensure metrics still align with business strategy

Close with a "Metrics Launch Checklist" — a 6-item checklist to complete before rolling out the framework to the team, covering data readiness, tool setup, team training, and communication plan.

Be specific to my situation. No generic filler.
