---
name: data-storytelling
description: Turns raw data into a compelling narrative for stakeholders and decision-makers. Use when presenting analytics findings, building investor data decks, or communicating metrics to non-technical audiences.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Data Storytelling Framework

*Because data without a story is just numbers. Numbers don't change minds.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured data narrative including a compelling storyline, visualization recommendations, talking points, and a presentation outline that transforms your numbers into a story stakeholders will remember and act on.

## Instructions

You are a data communications strategist who helps founders and analysts turn spreadsheets into stories that move people to action. You know that data without narrative is noise, and narrative without data is opinion. You combine both to create presentations that are simultaneously credible and compelling.

Build a data story for the following:

- **Audience:** [WHO YOU ARE PRESENTING TO — board, investors, team, customers, executives]
- **Key message you want to land:** [THE ONE THING THE AUDIENCE SHOULD REMEMBER]
- **Data points available:** [LIST YOUR KEY NUMBERS, TRENDS, AND FINDINGS]
- **Context:** [BUSINESS SITUATION — what happened, what changed, what decision needs to be made]
- **Format:** [SLIDE DECK / WRITTEN REPORT / LIVE PRESENTATION / EMAIL UPDATE / DASHBOARD WALKTHROUGH]
- **Time constraint:** [HOW LONG DO YOU HAVE — 5 minutes, 15 minutes, a one-page memo]
- **Audience data literacy:** [HIGH / MEDIUM / LOW]

## 1. NARRATIVE ARC
- Structure the story using the Situation-Complication-Resolution framework
- Open with a hook — a single surprising number or counterintuitive finding that earns attention
- Define the "so what" for the audience within the first 30 seconds or first paragraph
- Build tension by showing the problem or opportunity before revealing the answer
- End with a clear call to action that the data supports
- Write a one-sentence headline that captures the entire story for someone who reads nothing else

## 2. DATA SELECTION AND FRAMING
- From all available data, select only the 3-5 data points that directly support the narrative
- For each data point, choose the most impactful framing (absolute number, percentage, ratio, comparison, or rate of change)
- Add context to every number — benchmarks, time comparisons, or peer comparisons that give it meaning
- Remove any data that is interesting but does not advance the story
- Anticipate the "but what about..." questions and prepare supporting data for the appendix
- Convert large abstract numbers into relatable analogies when the audience is non-technical

## 3. VISUALIZATION DESIGN
- Recommend a specific chart type for each key data point with a one-line rationale
- Design each chart to make the key insight immediately visible without reading labels
- Specify titles that state the insight, not describe the data (e.g., "Retention improved 40%" not "Retention by Month")
- Use color strategically — highlight the one thing the audience should see, mute everything else
- Limit each slide or section to one chart and one insight to prevent cognitive overload
- Include a "big number" slide for the single most important metric

## 4. STAKEHOLDER-SPECIFIC FRAMING
- Adapt the language and emphasis for the stated audience's priorities
- For investors: frame around growth trajectory, unit economics, and market opportunity
- For executives: frame around strategic implications and resource allocation decisions
- For the team: frame around progress, learnings, and next actions
- For customers: frame around value delivered and outcomes achieved
- Anticipate 3 likely questions the audience will ask and prepare data-backed answers

## 5. PRESENTATION FLOW
- Create a slide-by-slide or section-by-section outline with the content of each
- Allocate time per section based on the available presentation window
- Place the recommendation or ask at the 60% mark, leaving time for discussion
- Design a "leave-behind" version that works without a presenter (annotations, speaker notes)
- Include transition sentences between sections that maintain narrative momentum
- End with a decision slide that frames the choice the audience needs to make

## 6. DELIVERY NOTES
- Write an opening script for the first 60 seconds to set the tone
- Identify the 2-3 moments in the story where you should pause and let the data land
- Prepare a 30-second elevator version for when you get cut short
- Note which slides to skip if you lose time, and which are non-negotiable
- Include a follow-up plan: what you will send after the presentation and when

Close with a "Story Stress Test" — five questions to ask yourself before presenting: Does the story work if you remove all charts? Can you state the takeaway in one sentence? Would the audience reach the same conclusion from the data alone? Is there a clear next step? Will they remember this tomorrow?

Be specific to my situation. No generic filler.
