---
name: dashboard-design
description: Designs an analytics dashboard with key metrics, layout, and drill-down logic. Use when building KPI dashboards, executive reporting views, or operational monitoring screens.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Analytics Dashboard Designer

*Because a dashboard nobody looks at is just a decoration.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete dashboard specification including metric selection, visual layout, chart types, filter logic, and drill-down paths — ready to hand to a designer or implement directly in your BI tool.

## Instructions

You are a business intelligence architect who has designed dashboards for fast-moving startups and data-heavy enterprises. You believe dashboards should drive decisions, not just display numbers. Every element you place earns its spot by answering a question someone actually asks.

Design an analytics dashboard for the following:

- **Dashboard purpose:** [EXECUTIVE OVERVIEW / MARKETING PERFORMANCE / PRODUCT USAGE / SALES PIPELINE / OPERATIONS / OTHER]
- **Primary audience:** [WHO WILL VIEW THIS — CEO, marketing team, product managers, etc.]
- **Key business questions this dashboard must answer:** [LIST 3-5 QUESTIONS]
- **Data sources available:** [LIST TOOLS/DATABASES, e.g., Google Analytics, Stripe, PostgreSQL, Mixpanel]
- **BI tool:** [METABASE / LOOKER / TABLEAU / GOOGLE DATA STUDIO / CUSTOM / UNDECIDED]
- **Refresh frequency needed:** [REAL-TIME / HOURLY / DAILY / WEEKLY]

## 1. METRIC SELECTION
- Select 4-6 primary KPIs that directly answer the stated business questions
- For each KPI, define the exact calculation formula and data source
- Add 2-3 secondary metrics that provide context for each primary KPI
- Include one health metric per KPI that signals when the number is unreliable (e.g., sample size, data freshness)
- Eliminate any vanity metrics that look good but do not drive action
- Assign a comparison benchmark to each metric (prior period, target, industry average)

## 2. LAYOUT ARCHITECTURE
- Design a top-level summary row with the 4-6 primary KPIs as scorecards
- Below the summary, group related metrics into 2-3 logical sections
- Specify the grid layout (e.g., 2-column, 3-column) and section hierarchy
- Place the most-checked metric in the top-left position following the F-pattern reading model
- Reserve the bottom section for detailed tables or lists that support drill-down
- Keep the dashboard to a single scroll-length — if it needs more, split into tabs

## 3. VISUALIZATION CHOICES
- Recommend the chart type for each metric with a one-line rationale (line for trends, bar for comparisons, table for detail)
- Specify time granularity per chart (daily, weekly, monthly) based on the metric's natural rhythm
- Use sparklines for compact trend indicators in scorecard tiles
- Avoid pie charts unless the data has 3 or fewer categories
- Include conditional formatting rules (red/yellow/green thresholds) for at-a-glance health checks
- Add comparison overlays (current vs. previous period) on trend charts

## 4. FILTERS AND INTERACTIVITY
- Define 3-5 global filters (date range, segment, channel, geography, product line)
- Specify default filter values that show the most useful starting view
- Design cross-filtering behavior so clicking one chart filters related charts
- Add drill-down paths from summary metrics to underlying detail views
- Include a "last updated" timestamp and data freshness indicator

## 5. ALERT AND ANNOTATION LAYER
- Define automated alerts for each primary KPI when it deviates beyond a threshold
- Specify alert channels (email, Slack, in-dashboard banner)
- Add an annotation system to mark events (launches, outages, campaigns) on time-series charts
- Include goal lines or target bands on trend charts so progress is visible
- Recommend a weekly snapshot email that summarizes dashboard highlights

## 6. IMPLEMENTATION GUIDE
- List the data transformations or queries needed for each metric
- Note any data joins required across sources
- Recommend a caching strategy based on the chosen refresh frequency
- Provide naming conventions for metrics, filters, and dashboard tabs
- Outline a testing checklist: verify each metric against a known source of truth before launch

End with a "Dashboard Review Checklist" — 7 yes/no questions the team should answer before shipping the dashboard to its audience (e.g., "Can a new viewer understand what to do within 5 seconds?").

Be specific to my situation. No generic filler.
