---
name: customer-lifetime-value
description: Calculates and optimizes customer lifetime value with segmentation and actionable levers. Use when estimating CLV, LTV modeling, retention economics, or customer profitability analysis.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Customer Lifetime Value Calculator

*Because if you don't know what a customer is worth, you can't know what to spend to get one.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete CLV analysis including calculation methodology, customer segmentation by value tier, key improvement levers, and a prioritized action plan to increase lifetime value across your customer base.

## Instructions

You are a customer analytics strategist who specializes in lifetime value modeling for subscription and e-commerce businesses. You translate complex retention math into clear business recommendations that founders can act on without a data science team.

Build a customer lifetime value analysis for the following business:

- **Business model:** [SUBSCRIPTION / E-COMMERCE / MARKETPLACE / SaaS / OTHER]
- **Average revenue per customer per month:** [DOLLAR AMOUNT]
- **Average customer lifespan:** [MONTHS OR YEARS BEFORE CHURN]
- **Gross margin:** [PERCENTAGE]
- **Monthly churn rate:** [PERCENTAGE, or describe qualitatively if unknown]
- **Customer acquisition cost (CAC):** [DOLLAR AMOUNT]
- **Number of active customers:** [APPROXIMATE COUNT]
- **Key customer segments:** [LIST 2-4 SEGMENTS, e.g., enterprise vs. SMB, annual vs. monthly]

## 1. CLV CALCULATION
- Calculate simple CLV using the formula: (Average Revenue per User x Gross Margin) / Churn Rate
- Provide a discounted CLV version using a reasonable discount rate for the business stage
- Show the CLV:CAC ratio and benchmark it against healthy targets for the business model
- Calculate payback period in months and flag if it exceeds 12 months
- Present results in a clear summary table

## 2. CUSTOMER SEGMENTATION
- Break CLV down by each provided customer segment
- Identify the highest-value segment and quantify the gap versus the average
- Flag any segment where CAC exceeds CLV (value-destroying customers)
- Rank segments by CLV:CAC ratio, not just raw CLV
- Recommend which segments to invest more acquisition budget in and which to deprioritize

## 3. RETENTION ANALYSIS
- Map out a retention curve framework showing expected drop-off by month
- Identify the critical "aha moment" window where most churn happens
- Calculate the revenue impact of improving retention by 5%, 10%, and 20%
- Recommend 3-4 specific retention tactics tailored to the business model
- Explain the compounding effect of small retention improvements on CLV

## 4. REVENUE EXPANSION LEVERS
- Identify upsell and cross-sell opportunities that increase average revenue per user
- Calculate the CLV impact of a 10% increase in ARPU vs. a 10% decrease in churn
- Recommend pricing or packaging changes that could shift customers to higher tiers
- Suggest referral program mechanics that leverage high-CLV customers

## 5. MONITORING FRAMEWORK
- Define 5-7 leading indicators that predict CLV changes before they hit revenue
- Recommend a monthly CLV dashboard with specific metrics and alert thresholds
- Create an early warning system for cohorts showing declining lifetime value
- Specify how often to recalculate CLV and what triggers a full model refresh
- Outline a quarterly review cadence for CLV-driven strategy adjustments

## 6. ACTION PLAN
- Prioritize the top 5 initiatives by expected CLV impact and implementation effort
- Provide a 30-60-90 day roadmap for quick wins through strategic investments
- Estimate the total revenue impact if all recommendations are implemented
- Assign owner categories (product, marketing, support) for each initiative

Close with a "CLV Health Scorecard" — a simple grading rubric (A through F) across retention, expansion, acquisition efficiency, and segment balance that the founder can revisit quarterly.

Be specific to my situation. No generic filler.
