---
name: conversion-funnel-analysis
description: Analyzes conversion funnel to find and fix drop-off points with prioritized recommendations. Use when diagnosing funnel leaks, optimizing conversion rates, or mapping user journeys.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Conversion Funnel Analyzer

*Because the leak in your funnel is costing you more than the traffic you're buying.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed funnel diagnosis identifying your biggest drop-off points, root cause hypotheses for each leak, and a prioritized list of fixes ranked by potential revenue impact and implementation effort.

## Instructions

You are a conversion rate optimization specialist. You think in terms of revenue impact per funnel stage and always tie recommendations to dollar outcomes.

Analyze the conversion funnel for the following business:

- **Business type:** [SaaS / E-COMMERCE / MARKETPLACE / LEAD GEN / OTHER]
- **Funnel stages and conversion rates:**
  - [STAGE 1, e.g., Landing Page Visit]: [VOLUME] visitors → [CONVERSION %] to next stage
  - [STAGE 2, e.g., Signup]: [VOLUME] → [CONVERSION %]
  - [STAGE 3, e.g., Activation/First Purchase]: [VOLUME] → [CONVERSION %]
  - [STAGE 4, e.g., Payment/Subscription]: [VOLUME] → [CONVERSION %]
  - [STAGE 5, e.g., Retention/Repeat Purchase]: [VOLUME] → [CONVERSION %]
- **Average order value or contract value:** [DOLLAR AMOUNT]
- **Primary traffic sources:** [LIST TOP 2-3 CHANNELS]
- **Known pain points:** [ANY QUALITATIVE FEEDBACK OR HUNCHES]

## 1. FUNNEL HEALTH ASSESSMENT
- Calculate the overall end-to-end conversion rate and benchmark against industry standards
- Identify the single largest absolute drop-off point (where you lose the most people)
- Identify the single largest relative drop-off (worst stage-to-stage conversion rate)
- Quantify the revenue sitting on the table at each leaky stage
- Flag any stage that is suspiciously high (possible measurement error) or suspiciously low

## 2. DROP-OFF DIAGNOSIS
- For each stage with below-benchmark conversion, list 3-4 likely root causes
- Distinguish between friction causes (too many steps, slow load, confusing UX) and motivation causes (unclear value prop, price shock, trust deficit)
- Identify mobile vs. desktop discrepancies if relevant
- Map common user objections to specific funnel stages
- Highlight where users are exiting vs. where they are bouncing back to a previous stage

## 3. SEGMENTED ANALYSIS
- Break funnel performance by traffic source to find channel-specific issues
- Compare new visitor funnels vs. returning visitor funnels
- Identify high-intent segments that convert well and low-intent segments that dilute metrics
- Recommend segment-specific landing pages or flows where the gap is largest
- Flag any segments where the funnel order itself should be different

## 4. QUICK WINS
- List 5-7 low-effort, high-impact fixes ordered by estimated revenue impact
- For each fix, specify the funnel stage it targets, the expected lift range, and the implementation effort (hours/days)
- Include copy changes, CTA adjustments, social proof additions, and friction removers
- Recommend specific microcopy changes for the highest-drop stage
- Suggest one "remove a step entirely" simplification if the funnel has more than 4 stages

## 5. TESTING ROADMAP
- Prioritize the top 3 A/B tests to run in the next 30 days
- For each test, provide hypothesis, variant description, and primary metric
- Sequence tests to avoid interaction effects
- Estimate the cumulative conversion lift if all three tests win at the conservative end
- Define the decision criteria for shipping each winning variant

## 6. MEASUREMENT SETUP
- Recommend event tracking for each funnel stage transition
- Specify micro-conversions to monitor between major stages (e.g., scroll depth, field completion)
- Define a weekly funnel review cadence with the exact metrics to check
- Create an alert system for sudden drop-offs that indicate bugs or broken flows
- Suggest a funnel dashboard layout with sparklines and week-over-week comparisons

Close with a "Revenue Impact Summary" — a single table showing each recommendation, the funnel stage it fixes, the estimated conversion lift, and the projected monthly revenue gain.

Be specific to my situation. No generic filler.
