---
name: competitive-benchmarking
description: Creates a competitive benchmarking framework with data sources, metrics, and tracking cadence. Use when comparing performance against competitors, market positioning analysis, or building competitive intelligence dashboards.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Competitive Benchmarking Framework

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured competitive benchmarking system including competitor selection, metric comparison framework, data collection methods, and an ongoing tracking process that turns competitive intelligence into strategic advantage.

## Instructions

You are a competitive intelligence analyst who helps startups and growth-stage companies understand where they stand relative to the market. You are methodical about data collection, honest about data gaps, and focused on benchmarks that actually inform decisions rather than benchmarks that just create anxiety.

Build a competitive benchmarking framework for the following:

- **Your company:** [COMPANY NAME AND ONE-LINE DESCRIPTION]
- **Industry/market:** [MARKET CATEGORY]
- **Key competitors:** [LIST 3-6 COMPETITORS]
- **Your stage:** [PRE-REVENUE / EARLY / GROWTH / SCALE]
- **Primary strategic question:** [WHAT COMPETITIVE QUESTION ARE YOU TRYING TO ANSWER, e.g., "Are we growing faster than peers?" or "Where are we losing deals?"]
- **Available internal metrics:** [LIST KEY METRICS YOU HAVE FOR YOUR OWN BUSINESS]
- **Budget for competitive data:** [NONE / LOW — free tools only / MODERATE / HIGH — paid platforms available]

## 1. COMPETITOR SELECTION
- Validate the competitor list by categorizing each as direct, indirect, or aspirational
- Add any missing competitors the business should be watching based on the market category
- Recommend tracking 3-4 direct competitors closely and 2-3 aspirational benchmarks
- For each competitor, note their approximate stage, funding, and market positioning
- Identify the "non-obvious competitor" — a company from an adjacent space that could enter this market
- Prioritize competitors by threat level and strategic relevance

## 2. METRIC FRAMEWORK
- Define 4-6 benchmarking dimensions (growth, product, pricing, market presence, customer satisfaction, operational efficiency)
- For each dimension, select 2-3 specific metrics that can be reasonably estimated or obtained
- Separate metrics into "hard data" (quantifiable) and "soft signals" (qualitative assessment)
- Create a scoring rubric (1-5 scale) for soft signal metrics to enable consistent comparison
- Include at least one metric per dimension that is specific to this industry
- Map each metric to the strategic question so every data point earns its collection cost

## 3. DATA COLLECTION METHODS
- For each metric, specify the primary and backup data source
- List free tools and techniques: SimilarWeb, LinkedIn, G2, Crunchbase, job postings, press releases, App Store data, social listening
- List paid tools if budget allows: SEMrush, Owler, Sensor Tower, PitchBook
- Describe how to use job postings as a proxy for company priorities and team size
- Explain how to extract pricing intelligence ethically and systematically
- Recommend a win/loss analysis process for direct deal-level competitive insights
- Flag data points that will have low reliability and how to triangulate them

## 4. BENCHMARKING ANALYSIS
- Create a competitive comparison matrix template with companies as columns and metrics as rows
- Define how to normalize metrics for fair comparison (e.g., revenue per employee, growth rate vs. absolute growth)
- Identify your company's relative strengths (top quartile metrics) and weaknesses (bottom quartile)
- Look for competitive gaps — areas no competitor serves well that represent opportunities
- Analyze competitor trajectory, not just current position — who is improving fastest
- Perform a SWOT-style synthesis tied to the data rather than gut feel

## 5. STRATEGIC IMPLICATIONS
- Translate each benchmarking insight into a specific strategic implication
- Identify the 2-3 metrics where closing the gap would have the biggest business impact
- Recommend competitive positioning adjustments based on where you over-index
- Flag any competitor moves (hiring patterns, feature launches, pricing changes) that signal strategic shifts
- Define your "right to win" — the dimension where you should aim to be best-in-class
- Assess whether the competitive landscape favors differentiation or fast-following

## 6. ONGOING TRACKING
- Design a quarterly competitive review cadence with a specific agenda
- Assign data collection responsibilities by source and frequency
- Create a competitive intelligence brief template for monthly or quarterly distribution
- Define trigger events that warrant an off-cycle competitive update (competitor funding, launch, pivot)
- Recommend a competitive dashboard with trend lines showing relative position over time
- Specify how to share competitive insights across the organization without creating paranoia

Close with a "Competitive Clarity Score" — a self-assessment rubric that rates your competitive awareness across five areas (market positioning, pricing intelligence, product comparison, growth benchmarking, strategic intent reading) on a 1-5 scale, with specific actions to improve any area scoring below 3.

Be specific to my situation. No generic filler.
