---
name: cohort-analysis
description: Sets up cohort analysis to understand retention and behavior patterns over time. Use when measuring retention curves, onboarding effectiveness, or comparing user groups by signup period.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Cohort Analysis Builder

*Because averages lie. Cohorts tell the truth.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete cohort analysis framework including cohort definitions, retention tables, behavior pattern comparisons, and specific recommendations to improve the metrics that matter most for each user group.

## Instructions

You are a product analytics expert who uses cohort analysis as the primary lens for understanding user behavior. You know that averages lie and that the only way to see true trends is to group users by when they started and watch what happens over time. You make retention math accessible to non-technical founders.

Build a cohort analysis for the following business:

- **Business type:** [SaaS / E-COMMERCE / MOBILE APP / MARKETPLACE / OTHER]
- **Cohort definition:** [SIGNUP DATE / FIRST PURCHASE DATE / SUBSCRIPTION START / OTHER]
- **Time granularity:** [WEEKLY / MONTHLY COHORTS]
- **Key action to measure retention:** [LOGIN / PURCHASE / FEATURE USE / SESSION / OTHER]
- **Observation window:** [HOW MANY WEEKS OR MONTHS OF DATA YOU HAVE]
- **Available data points:** [WHAT USER-LEVEL DATA YOU CAN ACCESS, e.g., signup date, plan type, referral source, activity timestamps]
- **Known changes:** [ANY PRODUCT LAUNCHES, PRICING CHANGES, OR CAMPAIGNS DURING THE OBSERVATION WINDOW]

## 1. COHORT STRUCTURE
- Define the cohort grouping criteria and time window for each cohort
- Recommend the optimal number of cohorts to analyze (typically 6-12)
- Specify the retention period intervals (Day 1, Day 7, Day 14, Day 30, etc.) based on the business model
- Determine minimum cohort size for statistical reliability
- Create a cohort table template with rows as cohorts and columns as time periods
- Label each cohort with any known external events that may affect its behavior

## 2. RETENTION CURVE ANALYSIS
- Calculate period-over-period retention rates for each cohort
- Identify the "critical drop-off point" — the time period with the steepest decline
- Compare early cohorts vs. recent cohorts to determine if retention is improving over time
- Calculate the flattening point where retention stabilizes for mature cohorts
- Estimate the long-term steady-state retention rate and what it implies for LTV
- Flag any cohort that behaves dramatically differently from the others and hypothesize why

## 3. BEHAVIORAL SEGMENTATION
- Within cohorts, segment users by a key behavioral dimension (e.g., activation actions completed, plan tier, referral source)
- Compare retention curves for each behavioral segment side by side
- Identify the "magic number" — the specific actions in the first week that predict long-term retention
- Quantify the retention gap between activated and non-activated users
- Recommend a behavioral activation checklist based on what high-retaining users do differently

## 4. TREND DETECTION
- Look for improving or declining cohort quality over time and tie trends to known changes
- Separate organic trend from seasonal effects by comparing same-season cohorts year over year if data allows
- Identify whether recent product or marketing changes are creating better or worse cohorts
- Calculate revenue-weighted retention to see if higher-value users retain differently
- Detect any "reactivation" patterns where users return after a period of inactivity

## 5. IMPROVEMENT OPPORTUNITIES
- Prioritize the single highest-leverage retention intervention based on the analysis
- Recommend 3-4 specific tactics to reduce drop-off at the critical decline point
- Suggest onboarding changes that would move more users past the activation threshold
- Identify re-engagement campaigns for cohorts that show the reactivation pattern
- Estimate the revenue impact of improving Day 30 retention by 5 and 10 percentage points

## 6. REPORTING SETUP
- Provide a cohort table template that can be rebuilt weekly or monthly
- Recommend the SQL query structure or analytics tool setup for automating cohort tracking
- Define a monthly review cadence with the specific questions to ask each time
- Specify alert thresholds for when a new cohort's early retention falls below historical norms
- Include a cohort comparison chart format that makes trends immediately visible to non-analysts

Close with a "Retention Health Summary" — three sentences covering where retention is strong, where the biggest leak is, and the single most impactful action to take this month.

Be specific to my situation. No generic filler.
