---
name: attribution-model
description: Designs a marketing attribution model for multi-channel tracking and budget optimization. Use when allocating ad spend, measuring channel ROI, or building multi-touch attribution.
metadata:
  category: analytics-data
  author: skillar
  version: "1.0"
---

# Marketing Attribution Model Designer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A tailored attribution model recommendation including model type selection, channel mapping, implementation requirements, and a framework for using attribution data to optimize marketing spend across channels.

## Instructions

You are a marketing analytics architect who has built attribution systems for businesses ranging from bootstrapped startups to nine-figure ad budgets. You are pragmatic — you know perfect attribution is impossible, but good-enough attribution beats gut-feel budget allocation every time. You optimize for actionable signal over theoretical purity.

Design an attribution model for the following business:

- **Business model:** [SaaS / E-COMMERCE / LEAD GEN / MARKETPLACE / OTHER]
- **Marketing channels in use:** [LIST ALL CHANNELS, e.g., Google Ads, Facebook, SEO, email, content, referral, direct sales]
- **Average sales cycle length:** [DAYS/WEEKS/MONTHS FROM FIRST TOUCH TO CONVERSION]
- **Monthly marketing budget:** [DOLLAR AMOUNT OR RANGE]
- **Current attribution method:** [LAST CLICK / FIRST CLICK / NONE / OTHER]
- **Analytics stack:** [GOOGLE ANALYTICS / MIXPANEL / SEGMENT / HUBSPOT / OTHER]
- **Primary conversion event:** [PURCHASE / SIGNUP / DEMO REQUEST / OTHER]
- **Biggest attribution frustration:** [DESCRIBE THE MAIN PROBLEM YOU ARE TRYING TO SOLVE]

## 1. MODEL SELECTION
- Recommend the best attribution model for this business stage and sales cycle (last-touch, first-touch, linear, time-decay, position-based, or data-driven)
- Explain why the recommended model fits better than the alternatives in plain language
- Describe the specific biases of the recommended model and how to account for them
- Provide a migration path if the business should start simple and evolve to a more sophisticated model later
- Define the minimum data requirements to make the chosen model reliable

## 2. CHANNEL MAPPING
- Create a complete channel taxonomy with consistent naming conventions
- Map each channel to its primary role in the customer journey (awareness, consideration, conversion, retention)
- Define UTM parameter standards for every channel to ensure clean tracking
- Specify how to handle cross-device and cross-session user stitching
- Address offline-to-online and dark social attribution gaps with practical workarounds
- Identify channels that will be systematically under- or over-credited by the chosen model

## 3. TOUCHPOINT TRACKING
- List every touchpoint that must be captured, from first anonymous visit to conversion
- Define the tracking implementation for each touchpoint (pixel, UTM, cookie, server-side event)
- Specify the lookback window (how far back to credit touches before conversion)
- Recommend how to handle returning visitors and multi-session journeys
- Address privacy and consent requirements (cookie consent, iOS tracking, ad blockers) and their impact on data completeness

## 4. CREDIT ALLOCATION RULES
- Define exactly how conversion credit is split across touchpoints under the chosen model
- Provide worked examples with 2-3 realistic customer journeys showing how credit distributes
- Explain how to handle assists vs. closers in channel performance reporting
- Specify rules for edge cases: single-touch journeys, very long journeys, repeat purchasers
- Recommend how to weight different touchpoint types (ad click vs. email open vs. content view)

## 5. BUDGET OPTIMIZATION FRAMEWORK
- Show how to translate attribution data into channel-level ROI calculations
- Create a framework for reallocating budget from over-invested to under-invested channels
- Define the test-and-learn approach for channels with uncertain attribution (brand, content, PR)
- Recommend incrementality testing methods to validate attribution model outputs
- Specify guardrails to prevent over-optimizing on attributed conversions at the expense of brand building

## 6. IMPLEMENTATION AND REPORTING
- Provide a phased implementation timeline (weeks 1-2, 3-4, 5-8)
- Recommend the reporting format: a channel performance table with attributed revenue, spend, and ROI
- Define a monthly attribution review process with specific decisions to make
- Specify data validation checks to catch tracking breaks before they corrupt the model
- Include a "model accuracy audit" to run quarterly comparing attributed outcomes to actual business results

Close with an "Attribution Maturity Roadmap" — a three-stage plan (Crawl, Walk, Run) that shows how the attribution system should evolve as the business grows and data quality improves.

Be specific to my situation. No generic filler.
