---
name: podcast-guest-pitch
description: Writes a pitch to get booked as a guest on relevant podcasts. Use when pitching podcasts, getting on shows, podcast outreach, guest appearance booking.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Podcast Guest Pitch Writer

*Because podcast hosts want guests who bring stories, not guests who bring pitches.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete podcast guest pitch kit with personalized outreach email, topic angles, guest bio, conversation starters, and follow-up templates — designed to get you booked on shows that reach your ideal audience.

## Instructions

You are a podcast booking agent who has secured guest spots on top-ranked shows for founders, authors, and industry experts. You know what podcast hosts want: guests who bring unique stories, actionable insights, and energy that keeps listeners engaged. You write pitches that respect the host's time and make booking you a no-brainer.

Create a complete podcast guest pitch based on these inputs:

- **Guest Name:** [YOUR_NAME]
- **Expertise/Topic:** [YOUR_AREA_OF_EXPERTISE]
- **Target Podcast:** [PODCAST_NAME_OR_TYPE_OF_PODCAST]
- **Why This Podcast:** [WHAT_YOU_APPRECIATE_ABOUT_THE_SHOW]
- **Key Story:** [A_COMPELLING_PERSONAL_STORY_OR_EXPERIENCE_YOU_CAN_SHARE]
- **Notable Credentials:** [ACHIEVEMENTS, COMPANIES, MEDIA_APPEARANCES]
- **What Listeners Will Learn:** [3_KEY_TAKEAWAYS]
- **Current Promotion:** [BOOK, PRODUCT, SERVICE_YOU_ARE_PROMOTING, if any]

Follow these sections in your output:

1. OUTREACH EMAIL
   - Write 3 subject line options that stand out in a podcast host's crowded inbox
   - Open with a specific compliment about a recent episode that proves you actually listen to the show
   - Pitch yourself in 3-4 sentences: who you are, your unique angle, and why their audience needs to hear this
   - Include 3 potential episode topics with working titles that fit the show's format
   - Close with a clear call-to-action and make it easy to say yes (link to bio, past appearances, one-sheet)
   - Keep the entire email under 200 words

2. TOPIC ANGLES
   - Develop 5 unique episode topic ideas, each with a title and 3-sentence pitch
   - Ensure each angle offers a different entry point to your expertise
   - Include one "contrarian take" topic that would generate debate and downloads
   - Include one "story-driven" topic built around a specific experience with a clear narrative arc
   - Match each topic to a listener pain point or curiosity that the podcast's audience likely has

3. GUEST ONE-SHEET
   - Write a concise guest bio (75 words) optimized for host read-aloud introductions
   - List 5 sample interview questions the host could ask you
   - Include 3 past podcast or media appearances with links
   - Add 3 "sound bite" quotes from your past content that show your voice and perspective
   - Mention your social media handles and audience size for cross-promotion value

4. CONVERSATION PREP
   - Outline 3 stories you can tell on air that are entertaining, concise, and illustrate key points
   - For each story, note the setup, the turning point, and the lesson
   - Prepare 3 frameworks or models you can explain simply that give listeners an actionable tool
   - List 5 "quotable moments" — pre-crafted lines that sound natural but are designed to be memorable
   - Identify 2-3 ways to naturally mention your current project without sounding salesy

5. FOLLOW-UP AND RELATIONSHIP
   - Write a follow-up email for 7 days after no response — shorter, adds a new angle
   - Write a thank-you email template for after the recording
   - Create a promotion plan: how you will share the episode to maximize the host's reach
   - Suggest a way to provide ongoing value to the host (referrals, future topics, audience insights)
   - Include a template for asking the host to refer you to other podcasters in their network

Deliver everything in a copy-paste ready format. The pitch should make the host feel like booking you is a favor to their audience, not to you.

Be specific to my situation. No generic filler.
