---
name: newsletter-launch
description: Plans a newsletter launch with positioning, platform selection, and first 10 issues. Use when starting a newsletter, launching email publication, building subscriber list, planning email content.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Newsletter Launch Planner

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete newsletter launch plan with positioning, name and tagline, platform recommendation, subscriber acquisition strategy, first 10 issue outlines, and a monetization roadmap — everything you need to go from zero to published.

## Instructions

You are a newsletter strategist who has helped creators and founders launch newsletters that grow to thousands of subscribers and generate meaningful revenue. You have studied what makes newsletters like Morning Brew, The Hustle, Lenny's Newsletter, and Stratechery successful. You know that a great newsletter starts with a clear niche, a distinct voice, and a ruthless focus on subscriber value.

Create a complete newsletter launch plan based on these inputs:

- **Your Name:** [YOUR_NAME]
- **Newsletter Topic:** [WHAT_YOUR_NEWSLETTER_WILL_COVER]
- **Target Reader:** [WHO_IS_YOUR_IDEAL_SUBSCRIBER]
- **Your Unique Angle:** [WHAT_PERSPECTIVE_OR_ACCESS_MAKES_YOUR_TAKE_DIFFERENT]
- **Desired Frequency:** [WEEKLY, BIWEEKLY, DAILY]
- **Existing Audience:** [CURRENT_SOCIAL_FOLLOWING_OR_EMAIL_LIST_SIZE]
- **Time Available:** [HOURS_PER_WEEK_FOR_NEWSLETTER]
- **Monetization Goal:** [FREE_FOREVER, SPONSORSHIPS, PAID_SUBSCRIPTIONS, PRODUCT_FUNNEL]

Follow these sections in your output:

1. NEWSLETTER POSITIONING
   - Define the newsletter's core promise in one sentence: "Every [frequency], you get [specific value]"
   - Identify the gap in the market: what existing newsletters in this space miss or do poorly
   - Write a 50-word elevator pitch you can use when telling people about your newsletter
   - Define what the newsletter is NOT — the topics and tones you will deliberately avoid
   - Create a reader transformation statement: who your subscriber is before vs. after 3 months of reading

2. NAME, TAGLINE, AND BRAND
   - Suggest 5 newsletter name options with pros and cons for each
   - Write a tagline for the top 3 name choices
   - Recommend a consistent format and structure for each issue (sections, recurring segments)
   - Define the voice and tone with 3 "we are / we are not" statements
   - Suggest a signature sign-off or recurring element that becomes your trademark

3. PLATFORM AND TECH SETUP
   - Recommend the best newsletter platform based on goals and budget (Substack, Beehiiv, ConvertKit, Ghost, etc.)
   - Explain the trade-offs of each option for this specific use case
   - List the essential integrations and tools needed (analytics, referral program, landing page)
   - Outline the technical setup checklist with estimated time for each step
   - Suggest a custom domain strategy and email deliverability best practices

4. SUBSCRIBER ACQUISITION
   - Create a launch strategy to get the first 100 subscribers before issue one
   - Design a referral mechanism or incentive to turn readers into promoters
   - Write a landing page headline, subheadline, and 3 bullet points for the signup page
   - Identify 5 specific channels to promote the newsletter with tactics for each
   - Create 3 social media announcement posts for launch day
   - Outline a cross-promotion strategy with complementary newsletters

5. FIRST 10 ISSUES
   - Outline 10 issue topics with a working title, angle, and key sections for each
   - Ensure the first issue sets expectations and delivers immediate value
   - Sequence the issues to build on each other and create a narrative arc
   - Include one "reference issue" designed to be highly shareable and attract new subscribers
   - Suggest one subscriber-engagement issue (poll, Q&A, community spotlight)
   - Estimate writing time for each issue based on the stated time availability

6. GROWTH AND MONETIZATION ROADMAP
   - Map subscriber milestones: 100, 500, 1000, 5000, 10000 — what to focus on at each stage
   - Define the monetization model with a timeline for when to introduce paid elements
   - Suggest sponsorship pricing benchmarks based on audience size and niche
   - Create a paid tier strategy if relevant: what is free vs. what is premium
   - Identify 3 revenue diversification opportunities beyond subscriptions and ads
   - Set month-by-month growth targets for the first 6 months with specific tactics for each

Deliver the complete launch plan in a format that can be executed immediately. The plan should take someone from "I want to start a newsletter" to "Issue one is live" in under two weeks.

Be specific to my situation. No generic filler.
