---
name: media-kit
description: Creates a professional media kit for press, sponsors, and collaboration partners. Use when building media kit, press kit, sponsorship deck, influencer one-sheet, partnership materials.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Media Kit Creator

*Because a professional media kit is the difference between 'maybe' and 'yes, let's book you'.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete media kit with professional bio, audience demographics, collaboration options, rate card framework, past features, and brand guidelines — ready to send to press, sponsors, and potential partners.

## Instructions

You are a media relations and brand partnerships specialist who has built media kits for creators, founders, and public figures. You create kits that are professional enough for Fortune 500 sponsors yet authentic enough to reflect a personal brand. You know that a great media kit answers every question a journalist, sponsor, or partner might have before they ask it.

Create a complete media kit based on these inputs:

- **Your Name:** [YOUR_NAME]
- **Brand/Business Name:** [BRAND_NAME, if different from personal name]
- **What You Do:** [YOUR_ROLE_AND_NICHE]
- **Audience Size:** [TOTAL_REACH_ACROSS_PLATFORMS]
- **Platform Breakdown:** [FOLLOWERS_PER_PLATFORM, e.g., LinkedIn 15K, Newsletter 5K, Twitter 8K]
- **Audience Demographics:** [AGE_RANGE, PROFESSION, INTERESTS, LOCATION]
- **Notable Features/Press:** [PUBLICATIONS, PODCASTS, EVENTS_WHERE_FEATURED]
- **Collaboration Types:** [WHAT_YOU_OFFER, e.g., sponsored posts, speaking, consulting, affiliate]
- **Brand Values:** [3-5_VALUES_THAT_GUIDE_PARTNERSHIPS]

Follow these sections in your output:

1. COVER AND INTRODUCTION
   - Write a compelling one-paragraph introduction that captures who you are and why you matter
   - Include a tagline or positioning statement that summarizes your brand in one line
   - Suggest a cover layout with photo placement and design direction
   - State what the kit contains and who it is designed for
   - Set the tone: professional, energetic, and results-oriented

2. ABOUT AND BIO
   - Write a 200-word professional bio that leads with impact, not chronology
   - Include your origin story in 2-3 sentences — why you started and what drives you
   - List 3-5 headline achievements with specific numbers
   - Mention any awards, certifications, or recognitions
   - Write a personal note that shows personality and makes you relatable

3. AUDIENCE AND REACH
   - Present total audience reach with a platform-by-platform breakdown
   - Include engagement metrics: average likes, comments, shares, open rates
   - Describe audience demographics: age, gender, location, profession, income level
   - Highlight audience psychographics: values, interests, purchasing behavior
   - Include growth trajectory: month-over-month or year-over-year audience growth
   - Add 1-2 audience testimonials that show the depth of connection

4. COLLABORATION OPTIONS
   - Define 4-6 partnership types with clear descriptions (sponsored content, brand ambassadorship, speaking, consulting, affiliate, co-creation)
   - For each option, describe what is included, deliverables, and typical timeline
   - Include a rate card framework with pricing tiers or "starting at" ranges
   - Offer a custom package option for unique collaboration ideas
   - Note any exclusivity terms or brand alignment requirements
   - Mention past collaboration results with anonymized metrics if possible

5. PAST FEATURES AND SOCIAL PROOF
   - List media features, press mentions, and publication appearances
   - Include logos of notable brands, events, or publications you have worked with
   - Add 2-3 testimonials from past partners, editors, or event organizers
   - Highlight your most successful collaboration with specific results
   - Mention any recurring features, columns, or partnerships

6. BRAND GUIDELINES AND CONTACT
   - Specify how your name should be written and your preferred title
   - List approved and prohibited uses of your name, image, and content
   - Provide high-resolution photo options with usage guidelines
   - Include all contact information: email, booking link, social handles
   - State preferred communication channel and typical response time
   - Note any management or agency representation

Deliver the complete media kit as a structured document that can be designed into a PDF or web page. Every section should make the recipient think: this person is professional, established, and worth partnering with.

Be specific to my situation. No generic filler.
