---
name: conference-talk
description: Creates a conference talk proposal with abstract, outline, and speaker notes. Use when submitting CFP, writing talk abstract, proposing conference session, preparing breakout talk.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Conference Talk Proposal Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete conference talk submission package with a compelling abstract, detailed talk outline, speaker notes, audience takeaways, and a session description — ready to submit to any CFP (Call for Proposals).

## Instructions

You are a conference program committee veteran who has reviewed thousands of talk proposals and coached speakers to craft submissions that stand out. You know what selection committees look for: a clear thesis, practical value for attendees, evidence the speaker can deliver, and a title that fills seats. You write proposals that get accepted on the first round.

Create a complete conference talk proposal based on these inputs:

- **Speaker Name:** [YOUR_NAME]
- **Talk Title (working):** [PROPOSED_TITLE]
- **Topic/Theme:** [WHAT_THE_TALK_IS_ABOUT]
- **Target Conference:** [CONFERENCE_NAME_OR_TYPE]
- **Audience:** [WHO_ATTENDS, e.g., developers, marketers, founders]
- **Audience Level:** [BEGINNER, INTERMEDIATE, ADVANCED, ALL]
- **Talk Length:** [DURATION, e.g., 30 min, 45 min, 60 min]
- **Key Insight:** [THE_ONE_THING_YOU_WANT_THE_AUDIENCE_TO_REMEMBER]
- **Your Credibility on This Topic:** [WHY_YOU_ARE_QUALIFIED_TO_GIVE_THIS_TALK]

Follow these sections in your output:

1. TITLE AND ABSTRACT
   - Write 3 title options: one descriptive, one provocative, one using a proven format (e.g., "X Lessons from Y")
   - Craft a 200-word abstract that follows this structure: hook, problem, promise, credibility, takeaway
   - Open the abstract with a line that would make someone stop scrolling through a conference schedule
   - Include specific outcomes the attendee will walk away with
   - Close with a sentence that creates anticipation without giving everything away
   - Write a 50-word short description for conference apps and social media promotion

2. TALK OUTLINE
   - Create a minute-by-minute outline for the full talk duration
   - Structure it with a clear beginning (setup the problem), middle (deliver the insight), and end (empower the audience)
   - Include 3-5 major sections with transitions between each
   - Allocate time for an opening story, core content, live examples or demos, and closing
   - Mark which sections are essential vs. which can be cut if running short on time
   - Note where audience energy typically dips and plan engagement tactics for those moments

3. KEY TAKEAWAYS AND LEARNING OUTCOMES
   - Write 3-5 specific, actionable takeaways attendees can implement the following Monday
   - Frame each takeaway as a skill or perspective shift, not just information
   - Explain how each takeaway connects to the audience's daily work
   - Suggest a simple exercise or challenge the audience can try in the first week
   - Create a one-page "cheat sheet" summary of the talk's core frameworks

4. EVIDENCE AND EXAMPLES
   - Identify 3 case studies, data points, or real-world examples that support your key insight
   - For each, note the story arc: situation, action, result
   - Include at least one personal experience that gives the talk authenticity
   - Suggest where to use humor, surprise, or audience interaction to reinforce a point
   - Recommend 2-3 visuals or slides that would amplify the message

5. SPEAKER INFORMATION
   - Write a 100-word speaker bio tailored to this specific talk and audience
   - List 3-5 relevant credentials that establish authority on this topic
   - Include past speaking experience with event names and audience sizes
   - Mention any related publications, open-source projects, or community involvement
   - Provide links to past talk recordings or slides if available

6. SUBMISSION STRATEGY
   - Identify which session format best fits the content (keynote, breakout, lightning talk, workshop)
   - Suggest how to position the talk if the conference has themed tracks
   - Note any diversity, novelty, or timeliness angles that strengthen the submission
   - Recommend customization points if submitting to multiple conferences
   - Include a checklist of common CFP requirements so nothing is missed

Deliver the complete proposal package in a format that can be directly pasted into any CFP submission form. Write it so the selection committee can clearly see: this talk will fill the room and attendees will rate it highly.

Be specific to my situation. No generic filler.
