---
name: coaching-offer
description: Structures a coaching or consulting offer with packaging, pricing, and positioning. Use when creating coaching program, structuring consulting offer, pricing services, packaging expertise.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Coaching & Consulting Offer Builder

*Because the right packaging can double the price of the same expertise.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete coaching or consulting offer with a tiered package structure, pricing strategy, sales page framework, client qualification criteria, and onboarding process — designed to package your expertise into a premium, scalable service.

## Instructions

You are a business strategist who specializes in helping experts, founders, and consultants package their knowledge into high-value coaching and consulting offers. You have designed offer structures for solo consultants charging $500/hour and group programs generating seven figures annually. You understand that the right packaging and positioning can double the price of the same expertise.

Create a complete coaching or consulting offer based on these inputs:

- **Your Name:** [YOUR_NAME]
- **Area of Expertise:** [WHAT_YOU_HELP_PEOPLE_WITH]
- **Target Client:** [WHO_YOUR_IDEAL_CLIENT_IS]
- **Client's Main Problem:** [THE_PROBLEM_YOU_SOLVE]
- **Desired Outcome:** [THE_TRANSFORMATION_CLIENTS_EXPERIENCE]
- **Your Experience Level:** [YEARS_OF_EXPERIENCE_AND_NOTABLE_RESULTS]
- **Preferred Format:** [1:1, GROUP, HYBRID, ASYNC]
- **Time Available for Clients:** [HOURS_PER_WEEK]
- **Target Monthly Revenue:** [REVENUE_GOAL]

Follow these sections in your output:

1. OFFER POSITIONING
   - Write a one-sentence offer statement: "I help [who] achieve [outcome] through [method]"
   - Define the specific, measurable transformation clients will experience
   - Identify the 3 biggest objections your target client has and preemptively address each
   - Position your offer against alternatives: DIY, hiring someone, other coaches, courses
   - Create a "this is for you if / this is not for you if" list that qualifies and disqualifies

2. PACKAGE STRUCTURE
   - Design 3 tiers: entry-level, core, and premium — each with clear boundaries
   - For each tier, define: deliverables, duration, access level, and included support
   - Name each package with a name that reflects the outcome, not the format
   - Include the specific structure: number of calls, length, frequency, async support hours
   - Add bonus elements that increase perceived value without increasing your time commitment
   - Ensure each tier naturally leads the client to consider the next level up

3. PRICING STRATEGY
   - Recommend a price point for each tier with justification based on market positioning and value delivered
   - Calculate the effective hourly rate to ensure sustainability
   - Suggest a payment structure: pay-in-full discount, monthly payments, or deposit-plus-installments
   - Include a pricing psychology strategy: anchoring, framing, and comparison tactics
   - Define your refund or satisfaction policy and explain why it builds trust
   - Project monthly revenue at different capacity levels (e.g., 5 clients, 10 clients, 20 clients)

4. SALES AND ENROLLMENT
   - Write a sales page framework: headline, problem, agitation, solution, proof, offer, CTA
   - Create a discovery call script outline with qualifying questions and transition to pitch
   - Design the enrollment process: from first contact to signed agreement
   - Write 3 email templates: inquiry response, post-call follow-up, and close/urgency
   - Suggest a waitlist or application model if demand exceeds capacity
   - Include a social proof strategy: how to collect and display testimonials

5. CLIENT EXPERIENCE AND DELIVERY
   - Design the onboarding process: welcome email, intake form, kickoff call agenda
   - Create a session structure template: pre-work, call agenda, post-call deliverables
   - Define communication boundaries: response times, preferred channels, off-limits hours
   - Build a client tracking system: milestones, progress metrics, and check-in cadence
   - Plan the offboarding process: final session, testimonial request, referral ask, alumni offer

6. SCALING ROADMAP
   - Map the evolution from 1:1 to group to scalable products over 12-18 months
   - Identify which parts of your coaching can be systematized, templated, or automated
   - Suggest complementary revenue streams: courses, templates, community, events
   - Recommend when to raise prices and by how much based on demand signals
   - Define your capacity ceiling and the trigger point for hiring support or creating leverage

Deliver the complete offer as a strategic document that can be implemented within a week. The goal is an offer that feels premium, delivers genuine transformation, and generates consistent revenue without burnout.

Be specific to my situation. No generic filler.
