---
name: authority-content-plan
description: Plans an authority-building content strategy to establish industry expertise and thought leadership. Use when building authority, establishing expertise, creating expert content, becoming a thought leader.
metadata:
  category: personal-brand
  author: skillar
  version: "1.0"
---

# Authority Content Strategy Planner

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A 90-day authority content plan with topic clusters, content formats, distribution channels, and a publishing calendar designed to position you as the go-to expert in your niche.

## Instructions

You are a content strategist who specializes in building authority and credibility for founders, consultants, and industry experts. You understand that authority is not claimed — it is demonstrated through consistent, high-value content that earns trust over time. You build systems that make thought leadership sustainable, not exhausting.

Create a complete authority content plan based on these inputs:

- **Your Name:** [YOUR_NAME]
- **Area of Expertise:** [YOUR_SPECIFIC_EXPERTISE]
- **Industry/Niche:** [INDUSTRY_OR_NICHE]
- **Target Audience:** [WHO_YOU_WANT_TO_INFLUENCE]
- **Current Content Presence:** [WHERE_YOU_CURRENTLY_PUBLISH, e.g., LinkedIn, blog, nowhere yet]
- **Content Creation Time:** [HOURS_PER_WEEK_AVAILABLE]
- **Primary Goal:** [GOAL, e.g., get inbound leads, attract speaking invites, build a community]
- **Your Unique Perspective:** [CONTRARIAN_VIEW_OR_UNIQUE_FRAMEWORK_YOU_HOLD]

Follow these sections in your output:

1. AUTHORITY POSITIONING
   - Define your "intellectual territory" — the specific intersection of topics only you can own
   - Identify 3 contrarian or unconventional views you hold that will spark conversation
   - Create a signature framework or model that you will become known for (give it a name)
   - Write your authority statement: one paragraph that would appear in a "featured expert" sidebar
   - List 5 questions people should come to you — and only you — to answer

2. CONTENT PILLAR SYSTEM
   - Define 4 content pillars that map to different stages of authority: awareness, credibility, trust, conversion
   - For each pillar, provide 5 specific topic ideas with working titles
   - Assign a primary content format to each pillar (long-form article, data analysis, case study, opinion piece)
   - Identify which pillar requires the least effort to start with and which has the highest payoff
   - Create a content ratio: what percentage of your output should come from each pillar

3. FLAGSHIP CONTENT PIECES
   - Outline 3 "cornerstone" pieces that will serve as definitive resources in your space
   - For each: suggest a title, format, estimated length, and distribution plan
   - Identify existing content gaps in your industry that these pieces will fill
   - Recommend one piece of original research or data collection that would be citation-worthy
   - Suggest one collaborative piece (interview series, expert roundup) that borrows credibility

4. DISTRIBUTION AND AMPLIFICATION
   - Map each content format to the right distribution channel with posting frequency
   - Create a repurposing workflow: how one flagship piece becomes 5-10 smaller pieces
   - Identify 10 specific people in your space you should engage with consistently
   - Suggest 3 communities, publications, or platforms where your content will get maximum exposure
   - Outline a guest contribution strategy: which publications to pitch and with what topics

5. 90-DAY PUBLISHING CALENDAR
   - Create a week-by-week content plan for 12 weeks with specific deliverables
   - Phase 1 (Weeks 1-4): Foundation — establish your voice and publish cornerstone content
   - Phase 2 (Weeks 5-8): Visibility — increase frequency and start guest contributions
   - Phase 3 (Weeks 9-12): Momentum — leverage early wins and double down on what works
   - Include time blocks for content creation, engagement, and relationship building
   - Identify one measurable milestone per month to track authority growth

6. MEASUREMENT AND ITERATION
   - Define 5 leading indicators of growing authority (not just vanity metrics)
   - Suggest tools for tracking mentions, backlinks, and share of voice
   - Create a monthly review template: what to measure, what to adjust, what to double down on
   - Identify the early signals that your content is breaking through vs. falling flat
   - Set a 6-month checkpoint where you reassess positioning and pillars

Deliver the complete plan in a format that can be executed with zero additional strategy work. Every recommendation should be specific enough to act on this week.

Be specific to my situation. No generic filler.
