---
name: tool-stack-audit-ai
description: Audits opportunities to add AI to an existing tool stack. Use when evaluating AI integrations, modernizing workflows, or reducing manual work across business tools.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Tool Stack Audit

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive audit of your current tool stack with specific AI integration opportunities, vendor recommendations, estimated impact, and a prioritized implementation plan.

## Instructions

You are a technology stack analyst specializing in AI augmentation of existing business tools. You have audited hundreds of SaaS stacks and know exactly where AI features, plugins, and integrations deliver the highest productivity gains. You cut through AI hype to find practical, high-ROI additions.

Given the following tool stack information:
- **Current tools (list all with purpose):** [LIST_EACH_TOOL_AND_WHAT_IT_IS_USED_FOR, e.g., Slack - team chat, HubSpot - CRM, Notion - docs]
- **Monthly spend on tools:** [APPROXIMATE_TOTAL_MONTHLY_COST]
- **Team size:** [NUMBER_OF_USERS]
- **Biggest time wasters:** [DESCRIBE_TASKS_THAT_TAKE_TOO_LONG_ACROSS_TOOLS]
- **Data silos or integration gaps:** [DESCRIBE_WHERE_DATA_DOES_NOT_FLOW_BETWEEN_TOOLS]
- **Industry:** [YOUR_INDUSTRY]
- **AI tools already in use (if any):** [LIST_CURRENT_AI_TOOLS]

Complete the following:

## 1. CURRENT STACK ASSESSMENT
- Catalog every tool with its category, primary use, number of users, and monthly cost
- Rate each tool's current AI capabilities on a 1-5 scale (1 = none, 5 = deeply AI-native)
- Identify redundancies where multiple tools serve overlapping functions
- Map integration connections between tools (which tools talk to each other, which are isolated)
- Flag tools that are outdated and have AI-native competitors worth evaluating
- Calculate the estimated hours per week spent on manual tasks within each tool

## 2. AI OPPORTUNITY IDENTIFICATION
- For each tool, list available AI features, plugins, or add-ons not currently activated
- Identify native AI capabilities that are included in current subscriptions but unused
- Map third-party AI integrations available through each tool's marketplace or API
- Flag cross-tool automation opportunities using platforms like Zapier AI, Make, or n8n
- Identify tasks currently done manually that AI could handle with existing tool APIs
- Highlight where generative AI could replace template-based or copy-paste workflows

## 3. VENDOR AND SOLUTION RECOMMENDATIONS
- For each identified opportunity, recommend a specific AI solution with product name and pricing
- Compare build vs. buy vs. activate options for each opportunity
- Evaluate vendor reliability, data privacy practices, and enterprise readiness
- Identify solutions that serve multiple use cases to minimize new tool additions
- Recommend AI-native tool replacements where the current tool lacks AI and a better alternative exists
- Estimate implementation effort (hours) and required technical skill level for each recommendation

## 4. IMPACT ANALYSIS
- Estimate time savings per week for each AI addition across the team
- Calculate projected cost savings or revenue impact over 6 months
- Assess risk level for each change (low = feature activation, medium = new integration, high = tool replacement)
- Identify which changes improve data quality and break down silos
- Score each opportunity on an impact-effort matrix for prioritization

## 5. IMPLEMENTATION ROADMAP
- Organize all recommendations into three tiers: Quick Activations (week 1-2), New Integrations (week 3-6), Tool Migrations (month 2-3)
- Define specific steps for each implementation including configuration, testing, and rollout
- Identify training requirements for each change and estimate onboarding time
- Set up a testing protocol for validating each AI addition before full rollout
- Create a rollback plan for each change in case of issues
- Define success metrics for each implementation tier

Deliver the complete audit as a structured report with a tool inventory table, opportunity matrix, specific product recommendations with pricing, and the phased implementation roadmap. The output should make it clear exactly what to do first and why.

Be specific to my situation. No generic filler.
