---
name: prompt-library-builder
description: Builds an organized prompt library for team or personal use. Use when creating prompt templates, standardizing AI usage, or onboarding teams to AI tools.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# Prompt Library Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete, categorized prompt library with reusable templates, usage guidelines, and quality benchmarks tailored to your specific workflows and team needs.

## Instructions

You are a prompt engineer and knowledge management specialist who designs prompt libraries used by high-performing teams at Fortune 500 companies. You understand that great prompts are reusable assets that compound in value over time when properly organized and documented.

Given the following context:
- **Team or individual role(s):** [ROLES, e.g., marketing team, solo founder, engineering squad]
- **Primary AI tools used:** [TOOLS, e.g., ChatGPT, Claude, Midjourney, Copilot]
- **Key use cases:** [LIST_5_TO_10_TASKS_YOU_USE_AI_FOR]
- **Current prompt challenges:** [DESCRIBE_FRUSTRATIONS_WITH_CURRENT_PROMPTS]
- **Output quality standards:** [DESCRIBE_WHAT_GOOD_OUTPUT_LOOKS_LIKE]
- **Team size:** [NUMBER_OF_PEOPLE_WHO_WILL_USE_THE_LIBRARY]

Complete the following:

## 1. PROMPT AUDIT AND CATEGORIZATION
- Review the listed use cases and group them into 4-6 logical categories (e.g., Content Creation, Data Analysis, Customer Communication)
- For each category, identify the 3-5 most frequently needed prompt types
- Assess which tasks require single-turn prompts vs. multi-turn conversation chains
- Flag prompts that need domain-specific context or persona definitions
- Identify shared variables that appear across multiple prompts (brand voice, audience, formatting rules)

## 2. TEMPLATE DESIGN
- Create a standardized prompt template format with these fields: Title, Category, Purpose, Variables (in [BRACKET] format), Prompt Body, Expected Output Format, Quality Checklist
- Write 3 fully fleshed-out prompt templates for each identified category
- Include a system/persona instruction block where applicable
- Build in output format specifications (bullet points, tables, specific word counts, etc.)
- Add chain-of-thought instructions for complex reasoning tasks
- Include fallback instructions for when the AI produces off-target results

## 3. VARIABLE SYSTEM
- Create a master variable glossary with all reusable placeholders across the library
- Define default values for common variables (brand voice descriptors, target audience, formatting preferences)
- Build a context-injection template that can prepend any prompt with standard business context
- Design variable validation rules to prevent incomplete prompt submissions
- Create a quick-reference card mapping variables to their definitions

## 4. QUALITY FRAMEWORK
- Define 3-5 output quality criteria specific to each category (accuracy, tone, completeness, actionability, format compliance)
- Create a simple 1-5 scoring rubric for evaluating prompt outputs
- Write 1 gold-standard example output for each prompt category
- Build an iteration guide showing how to refine prompts that score below threshold
- Include A/B testing suggestions for optimizing critical prompts

## 5. ORGANIZATION AND ACCESS
- Design a folder/tagging structure for the library (by category, by role, by frequency of use)
- Create a searchable index with prompt titles, descriptions, and tags
- Write a one-page quick-start guide for new team members
- Suggest a storage platform and format (Notion, Google Docs, GitHub, etc.) based on team size
- Define a review cadence for updating and retiring stale prompts

## 6. GOVERNANCE AND MAINTENANCE
- Establish a prompt contribution process for team members to submit new prompts
- Define version control practices for prompt iteration tracking
- Create a feedback mechanism for rating prompt effectiveness after each use
- Set quarterly review milestones to prune underperforming prompts and promote top performers
- Draft a brief AI usage policy covering prompt sharing, data sensitivity, and approved tools

Deliver the complete prompt library as a structured document with all templates ready to copy-paste, a master index, and the governance framework. Each prompt template should be immediately usable with no additional editing beyond filling in the bracketed variables.

Be specific to my situation. No generic filler.
