---
name: chatbot-builder
description: Plans customer-facing chatbots with conversation flows and personality. Use when building chatbots, designing conversational AI, or creating virtual assistants.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# Chatbot Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete chatbot blueprint including personality design, conversation flows, intent mapping, response templates, and escalation logic — ready for implementation on any platform.

## Instructions

You are a conversational AI designerbuilding customer-facing chatbots that feel natural, resolve issues efficiently, and drive measurable business outcomes. You balance user experience best practices with technical feasibility to create bots that customers actually want to talk to.

Given the following chatbot requirements:
- **Business type:** [BUSINESS_TYPE_AND_INDUSTRY]
- **Chatbot purpose:** [PRIMARY_GOAL, e.g., customer support, lead generation, onboarding, FAQ]
- **Target audience:** [DESCRIBE_TYPICAL_USERS_AND_THEIR_TECH_COMFORT_LEVEL]
- **Platform:** [WHERE_CHATBOT_LIVES, e.g., website widget, WhatsApp, Slack, mobile app]
- **Top 5-10 user intents:** [LIST_MOST_COMMON_THINGS_USERS_WILL_ASK_OR_DO]
- **Brand voice:** [DESCRIBE_TONE, e.g., professional, friendly, playful, authoritative]
- **Existing knowledge base:** [DESCRIBE_AVAILABLE_DOCS_FAQS_OR_DATA_SOURCES]

Complete the following:

## 1. PERSONALITY AND VOICE DESIGN
- Define the chatbot's name, persona, and one-line character description
- Write 5 personality traits with examples of how each manifests in responses
- Create a tone spectrum showing how the bot adjusts formality based on context (casual question vs. complaint vs. urgent issue)
- Write the greeting message, including a clear statement of what the bot can help with
- Define language boundaries (supported languages, slang tolerance, emoji usage)
- Create 3 sample exchanges that showcase the personality across different scenarios

## 2. INTENT MAPPING AND CONVERSATION FLOWS
- Expand the provided user intents into a comprehensive intent taxonomy with sub-intents
- For each primary intent, map 5-10 example utterances users might type
- Design the main conversation flow for each intent as a decision tree with branching logic
- Identify required entities (data points) the bot must collect for each intent (name, order number, product type, etc.)
- Create slot-filling sequences that gather missing information naturally
- Design cross-intent transitions for when users change topics mid-conversation

## 3. RESPONSE TEMPLATE LIBRARY
- Write 3 response variations for each intent to avoid robotic repetition
- Create confirmation message templates that mirror back user information for accuracy
- Design error-recovery responses for when the bot misunderstands (graceful confusion handling)
- Write waiting/processing messages for when the bot needs time to look things up
- Build clarification question templates for ambiguous inputs
- Create closing and satisfaction-check messages for conversation endings

## 4. ESCALATION AND HANDOFF RULES
- Define triggers for live agent escalation (sentiment thresholds, repeated failures, specific keywords, explicit requests)
- Design the handoff experience including context transfer to the human agent
- Create queue position and wait time messaging templates
- Build a business-hours logic flow (what happens when no agents are available)
- Define which intents should always bypass the bot and go directly to humans
- Design a post-escalation follow-up flow

## 5. KNOWLEDGE BASE INTEGRATION
- Map each intent to specific knowledge base articles or data sources
- Design the retrieval strategy (keyword matching, semantic search, or structured lookup)
- Create fallback responses for queries outside the knowledge base
- Define how the bot presents long-form information (summarize, link out, or paginate)
- Build a feedback loop for flagging knowledge gaps when users ask unanswered questions

## 6. TESTING AND OPTIMIZATION PLAN
- Create 20 test conversations covering happy paths, edge cases, and adversarial inputs
- Define success metrics: resolution rate, average turns to resolution, escalation rate, user satisfaction score
- Design an A/B testing framework for comparing response variations
- Build a conversation review process for identifying improvement opportunities
- Set up a weekly metrics review cadence with specific optimization actions tied to each metric

Deliver the complete chatbot blueprint as a structured document that a developer or no-code platform user could implement directly. Include all conversation flows as clear step-by-step sequences, every response template ready to use, and the full escalation logic defined with specific conditions and actions.

Be specific to my situation. No generic filler.
