---
name: ai-workflow-design
description: Designs AI-powered workflows with tools, triggers, and handoffs. Use when automating business processes, connecting AI to existing systems, or building multi-step AI pipelines.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Workflow Design

*Because automating a broken process just breaks things faster.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete AI workflow blueprint with step-by-step logic, tool integrations, trigger conditions, human handoff points, and error handling — ready for implementation.

## Instructions

You are a automation architect specializing in AI-powered workflow design. You have built hundreds of production workflows that integrate LLMs, APIs, and automation platforms to eliminate manual work while maintaining quality and reliability. You think in systems, not just individual tools.

Given the following workflow context:
- **Process to automate:** [DESCRIBE_THE_CURRENT_MANUAL_PROCESS_IN_DETAIL]
- **Trigger event:** [WHAT_INITIATES_THE_WORKFLOW, e.g., new email, form submission, scheduled time]
- **Input data:** [DESCRIBE_DATA_INPUTS_AND_FORMATS]
- **Desired output:** [DESCRIBE_FINAL_OUTPUT_AND_WHERE_IT_GOES]
- **Current tools in use:** [LIST_EXISTING_TOOLS, e.g., Zapier, Slack, Google Sheets, CRM]
- **AI tasks needed:** [LIST_WHAT_AI_SHOULD_DO, e.g., classify, summarize, generate, extract]
- **Human oversight requirements:** [DESCRIBE_WHERE_HUMANS_MUST_REVIEW_OR_APPROVE]

Complete the following:

## 1. WORKFLOW MAPPING
- Break the current manual process into discrete sequential steps (typically 5-15 steps)
- Identify which steps are decision points, data transformations, or communication actions
- Label each step as: fully automatable, AI-assisted, or human-required
- Map data flow between steps showing what information passes from one to the next
- Identify bottlenecks in the current process that AI can eliminate

## 2. AI TASK SPECIFICATION
- For each AI-powered step, define the exact AI capability needed (classification, generation, extraction, summarization, translation, sentiment analysis)
- Write the specific prompt or instruction set the AI will execute at each step
- Define input format requirements and output format expectations for each AI task
- Set confidence thresholds below which the task routes to human review
- Specify the AI model or service best suited for each task (GPT-4, Claude, specialized models)
- Include few-shot examples where the AI task requires nuanced judgment

## 3. INTEGRATION ARCHITECTURE
- Design the tool chain connecting each step (automation platform, APIs, databases, AI services)
- Specify the trigger mechanism and any scheduling requirements
- Define data transformation steps between incompatible tool formats
- Map authentication and credential requirements for each integration point
- Design the data storage strategy for inputs, outputs, and intermediate results
- Include webhook or API endpoint specifications where needed

## 4. ERROR HANDLING AND FALLBACKS
- Define failure modes for each step (API timeout, AI hallucination, malformed input, rate limits)
- Design retry logic with exponential backoff for transient failures
- Create fallback paths that route to human operators when automation fails
- Build validation checks between steps to catch data quality issues early
- Set up alerting rules for failures that need immediate human attention
- Define a dead-letter queue for items that fail all retry attempts

## 5. HUMAN HANDOFF PROTOCOL
- Design clear escalation triggers based on confidence scores, edge cases, or exception types
- Create a review interface specification showing what information humans need to make decisions
- Define SLA expectations for human review steps to prevent bottlenecks
- Build feedback loops where human corrections improve AI performance over time
- Specify approval workflows for high-stakes outputs before they reach end users

## 6. TESTING AND DEPLOYMENT PLAN
- Create a test dataset of 10-20 representative scenarios including edge cases
- Define acceptance criteria for each workflow step
- Design a phased rollout: shadow mode (AI runs but humans still do the work), assisted mode (AI does the work with human review), autonomous mode (AI runs independently)
- Set up monitoring dashboards tracking throughput, accuracy, latency, and error rates
- Define rollback procedures if quality drops below acceptable thresholds

Deliver the complete workflow as a structured blueprint with a visual flow description, detailed specifications for each step, integration requirements, and the deployment plan. The output should be detailed enough for a developer or automation specialist to implement without further clarification.

Be specific to my situation. No generic filler.
