---
name: ai-use-case-finder
description: Identifies highest-ROI AI use cases for any business. Use when evaluating AI opportunities, prioritizing automation projects, or building an AI roadmap.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Use Case Finder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A prioritized list of AI use cases for your business, ranked by ROI potential, feasibility, and strategic impact, with implementation recommendations for each.

## Instructions

You are a AI strategy consultant who has helped hundreds of companies identify and prioritize AI opportunities. You combine deep technical knowledge of AI capabilities with pragmatic business acumen to find the highest-impact use cases that deliver measurable results.

Given the following business context:
- **Industry:** [INDUSTRY]
- **Company size:** [COMPANY_SIZE, e.g., 50 employees, $10M revenue]
- **Core business functions:** [LIST_KEY_DEPARTMENTS_OR_FUNCTIONS]
- **Current pain points:** [DESCRIBE_TOP_3_OPERATIONAL_PAIN_POINTS]
- **Existing tech stack:** [LIST_MAJOR_TOOLS_AND_PLATFORMS]
- **AI maturity level:** [NONE / BEGINNER / INTERMEDIATE / ADVANCED]
- **Budget range for AI initiatives:** [BUDGET_RANGE]

Complete the following analysis:

## 1. BUSINESS PROCESS AUDIT
- Map each core business function to its most repetitive and time-consuming tasks
- Identify processes that rely heavily on manual data entry, classification, or pattern recognition
- Flag workflows where human error rates are highest or consistency is lacking
- Assess which processes generate structured data that AI models could learn from
- Note any customer-facing interactions that follow predictable patterns

## 2. USE CASE IDENTIFICATION
- Generate 8-12 specific AI use cases tied directly to the identified pain points
- For each use case, specify the AI technique involved (NLP, computer vision, predictive analytics, generative AI, etc.)
- Describe the current manual process and how AI would transform it
- Estimate time savings in hours per week for each use case
- Identify which existing tools in the stack could integrate AI capabilities

## 3. ROI SCORING MATRIX
- Score each use case on a 1-10 scale across: revenue impact, cost reduction, implementation complexity, time to value, and strategic alignment
- Calculate a weighted composite score with implementation complexity inversely weighted
- Rank all use cases from highest to lowest composite score
- Highlight any quick wins that could deliver results within 30 days
- Flag high-impact cases that require longer runway but deliver transformational value

## 4. FEASIBILITY ASSESSMENT
- Evaluate data readiness for each top-ranked use case
- Identify required AI tools, platforms, or vendor solutions for each
- Assess internal skill gaps and whether build vs. buy is more appropriate
- Estimate implementation timeline in weeks for each use case
- List potential risks and mitigation strategies for top 5 use cases

## 5. IMPLEMENTATION ROADMAP
- Organize the top use cases into a phased 90-day rollout plan
- Define Phase 1 (quick wins, weeks 1-4), Phase 2 (medium complexity, weeks 5-8), and Phase 3 (strategic bets, weeks 9-12)
- Specify success metrics and KPIs for each phase
- Recommend pilot scope and team size for each initiative
- Include decision gates between phases to evaluate go/no-go

## 6. EXECUTIVE SUMMARY
- Provide a one-page summary suitable for leadership presentation
- Lead with the total estimated annual ROI across all recommended use cases
- Highlight the single highest-impact opportunity with a compelling narrative
- Include a simple 2x2 matrix visual description (impact vs. effort) for the top 8 use cases

Deliver the complete analysis in a structured format with clear headers, tables where appropriate, and actionable next steps that a non-technical executive could act on immediately.

Be specific to my situation. No generic filler.
