---
name: ai-sales-assistant
description: Creates AI sales assistants for lead qualification and follow-up. Use when automating lead scoring, building sales outreach sequences, or designing AI-powered sales workflows.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Sales Assistant

*Because AI should prep the salesperson, not replace the conversation.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete AI sales assistant system with lead scoring logic, qualification workflows, personalized outreach sequences, follow-up automation, and CRM integration specifications.

## Instructions

You are a sales operations architect who designs AI-powered sales systems that help teams close more deals with less manual effort. You have built AI sales assistants for B2B and B2C companies that consistently improve conversion rates by 20-40% while reducing time spent on unqualified leads.

Given the following sales context:
- **Product or service sold:** [DESCRIBE_WHAT_YOU_SELL_AND_PRICE_RANGE]
- **Target customer profile:** [DESCRIBE_IDEAL_CUSTOMER, e.g., SaaS companies, 50-200 employees, VP of Engineering]
- **Sales cycle length:** [TYPICAL_TIME_FROM_LEAD_TO_CLOSE]
- **Current lead sources:** [LIST_WHERE_LEADS_COME_FROM, e.g., website forms, LinkedIn, referrals, events]
- **Monthly lead volume:** [NUMBER_OF_NEW_LEADS_PER_MONTH]
- **Sales team size:** [NUMBER_OF_REPS]
- **CRM and tools:** [LIST_SALES_TOOLS, e.g., Salesforce, HubSpot, Outreach, LinkedIn Sales Navigator]
- **Current conversion rate:** [LEAD_TO_CUSTOMER_CONVERSION_RATE]

Complete the following:

## 1. LEAD SCORING MODEL
- Design a point-based lead scoring system with demographic, firmographic, and behavioral criteria
- Define scoring weights for: company size, industry match, job title, budget signals, engagement actions (email opens, page visits, content downloads)
- Create score thresholds that classify leads as: Hot (sales-ready), Warm (nurture), Cold (disqualify)
- Build negative scoring triggers for disqualification signals (wrong industry, too small, competitor)
- Design a lead decay model that reduces scores over time without engagement
- Include a company-level rollup score when multiple contacts exist at the same account

## 2. QUALIFICATION WORKFLOW
- Design an AI-powered qualification sequence that gathers BANT (Budget, Authority, Need, Timeline) or MEDDIC information
- Create conversation scripts the AI uses to qualify leads via chat, email, or form follow-up
- Build branching logic based on qualification responses (budget confirmed routes to demo, no budget routes to nurture)
- Define the minimum qualification criteria required before routing to a human rep
- Create a discovery question bank organized by qualification framework stage
- Design an objection handling library for common early-stage pushbacks

## 3. PERSONALIZED OUTREACH ENGINE
- Design a multi-channel outreach sequence (email, LinkedIn, SMS) with 5-7 touchpoints over 14-21 days
- Create AI-generated email templates that personalize based on: company name, industry, role, recent company news, and pain point signals
- Build subject line and opening line variations based on lead source and engagement history
- Design A/B testing rules for subject lines, send times, and message length
- Create follow-up logic that adapts the next message based on the recipient's behavior (opened, clicked, replied, no response)
- Include cadence rules for spacing, channel rotation, and maximum total touches before auto-disqualification

## 4. CRM INTEGRATION AND DATA FLOW
- Map the data flow from lead source through scoring, qualification, and outreach to CRM updates
- Define which CRM fields the AI assistant reads from and writes to at each stage
- Design automated CRM activity logging for every AI interaction (emails sent, qualification data gathered, score changes)
- Create deal stage advancement rules triggered by qualification milestones
- Build pipeline reporting views showing AI-influenced vs. manual lead progression
- Define data hygiene rules the AI enforces (standardize job titles, enrich missing fields, flag duplicates)

## 5. HANDOFF TO HUMAN REPS
- Define the handoff trigger criteria: qualification score met, meeting requested, high-value account identified
- Design the handoff package: lead summary, qualification notes, engagement history, recommended next steps, and conversation context
- Create internal notification templates (Slack, email, CRM task) that alert reps to new qualified leads
- Build a rep assignment logic based on territory, industry expertise, capacity, or round-robin
- Define SLA expectations for rep response after handoff with escalation if missed
- Design a feedback loop where reps rate lead quality to improve the scoring model

## 6. PERFORMANCE TRACKING AND OPTIMIZATION
- Define key metrics: lead-to-qualified rate, qualified-to-opportunity rate, outreach response rate, time to first response, cost per qualified lead
- Create a weekly performance dashboard comparing AI-assisted vs. baseline metrics
- Design an optimization cycle that adjusts scoring weights based on which leads actually convert
- Build a monthly review process analyzing lost deals to identify qualification gaps
- Set 30-60-90 day performance targets with specific improvement milestones
- Create an ROI calculator showing time saved per rep and incremental revenue generated

Deliver the complete AI sales assistant design as an operational playbook with all scoring criteria, outreach templates, qualification scripts, and integration specifications ready for implementation. The output should enable a sales operations team to configure and launch within two weeks.

Be specific to my situation. No generic filler.
