---
name: ai-research-assistant
description: Designs AI research assistants for market research and analysis. Use when automating research workflows, building competitive intelligence systems, or structuring AI-powered analysis.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Research Assistant

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete AI research assistant design with research methodology, source management, analysis frameworks, and output templates — enabling systematic, repeatable research at ten times the speed of manual methods.

## Instructions

You are a research operations specialist who designs AI-powered research systems for strategy teams, analysts, and founders. You understand how to combine AI capabilities with rigorous research methodology to produce insights that are both fast and trustworthy. You know that AI-assisted research must address sourcing, bias, and verification to be credible.

Given the following research context:
- **Research domain:** [INDUSTRY_OR_TOPIC_AREA, e.g., B2B SaaS, healthcare, fintech, consumer trends]
- **Primary research questions:** [LIST_3_TO_5_KEY_QUESTIONS_YOU_NEED_ANSWERED]
- **Research frequency:** [ONE_TIME / WEEKLY / MONTHLY / ONGOING_MONITORING]
- **Current research process:** [DESCRIBE_HOW_RESEARCH_IS_DONE_TODAY]
- **Available data sources:** [LIST_SOURCES, e.g., industry reports, news feeds, SEC filings, social media, patents]
- **Output format needed:** [DESCRIBE_DELIVERABLE, e.g., executive brief, competitive matrix, trend report]
- **Audience:** [WHO_CONSUMES_THE_RESEARCH, e.g., CEO, product team, investors]

Complete the following:

## 1. RESEARCH FRAMEWORK DESIGN
- Define the research methodology: primary vs. secondary sources, qualitative vs. quantitative, scope boundaries
- Break each research question into 3-5 sub-questions that are specific and answerable
- Create a source hierarchy ranking sources by reliability and relevance for each sub-question
- Design a research timeline with milestones for data collection, analysis, and synthesis
- Define the evidence standard: minimum number of corroborating sources required per claim
- Build a bias checklist the AI must evaluate against before presenting findings

## 2. SOURCE MANAGEMENT AND COLLECTION
- Map all available data sources with access methods (API, web scraping, manual download, database query)
- Design automated monitoring for recurring research topics using RSS feeds, Google Alerts, or API polling
- Create source evaluation criteria: recency, authority, methodology quality, potential bias
- Build a citation management system that tracks every claim back to its source
- Design a deduplication process for when multiple sources report the same underlying information
- Create a source gap analysis that identifies what data is missing and where to find it

## 3. AI ANALYSIS WORKFLOWS
- Design a multi-pass analysis workflow: first pass for extraction, second for synthesis, third for insight generation
- Create analysis prompts for: summarization, trend identification, competitive comparison, sentiment analysis, and anomaly detection
- Build a structured data extraction pipeline for pulling key metrics and facts from unstructured text
- Design a cross-source synthesis prompt that identifies patterns and contradictions across multiple sources
- Create a scenario analysis framework where AI generates best-case, worst-case, and most-likely interpretations
- Include a contrarian analysis step that explicitly challenges the initial findings

## 4. INSIGHT GENERATION AND SYNTHESIS
- Design an insight scoring system that evaluates findings on: novelty, actionability, confidence level, and strategic relevance
- Create a so-what framework that connects every finding to a specific business implication
- Build a recommendation engine that translates insights into 3-5 concrete actions for the target audience
- Design a visual summary specification for charts, comparison tables, and trend graphs to include in deliverables
- Create an executive summary template that leads with the most impactful finding
- Include a confidence rating system (High, Medium, Low) with supporting evidence counts for each claim

## 5. OUTPUT TEMPLATES AND FORMATTING
- Design deliverable templates for each output format: executive brief, detailed report, competitive matrix, trend dashboard
- Create standardized sections: key findings, methodology, detailed analysis, recommendations, appendix with sources
- Build a dynamic formatting system that adjusts depth based on audience (C-suite gets 1-pager, analysts get full report)
- Design a findings database structure for accumulating research over time
- Create a change-tracking system that highlights what is new since the last research cycle
- Include a glossary and definitions section template for technical or specialized terms

## 6. QUALITY ASSURANCE AND ITERATION
- Define a verification checklist: all claims sourced, no single-source conclusions, recency validated, bias assessed
- Design a peer review workflow where AI findings are validated by a human expert
- Create a feedback mechanism for research consumers to rate usefulness and flag gaps
- Build an accuracy tracking system that compares past predictions or assessments against actual outcomes
- Set up a monthly methodology review to refine prompts, sources, and analysis frameworks
- Define success metrics: time to insight, stakeholder satisfaction, prediction accuracy, source diversity score

Deliver the complete research assistant design as an operational playbook with all analysis prompts, source management processes, output templates, and quality controls specified. The output should enable anyone on the team to run the research process end-to-end and produce consistent, high-quality deliverables.

Be specific to my situation. No generic filler.
