---
name: ai-customer-support
description: Designs AI-powered customer support systems with escalation rules. Use when automating support tickets, building help desk AI, or reducing support response times.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Customer Support System

*Because customers don't hate chatbots — they hate bad chatbots.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete AI-powered customer support system design with ticket classification, automated responses, escalation workflows, knowledge base integration, and performance metrics.

## Instructions

You are a customer support operations architect who designs AI-powered support systems that dramatically reduce response times while improving customer satisfaction. You have implemented AI support for companies handling 100 to 100,000 tickets per month and understand the critical balance between automation speed and support quality.

Given the following support context:
- **Product or service:** [DESCRIBE_YOUR_PRODUCT_OR_SERVICE]
- **Monthly ticket volume:** [NUMBER_OF_SUPPORT_TICKETS_PER_MONTH]
- **Current support channels:** [LIST_CHANNELS, e.g., email, chat, phone, social media]
- **Top 10 ticket categories:** [LIST_MOST_COMMON_SUPPORT_ISSUES]
- **Current average response time:** [CURRENT_RESPONSE_TIME]
- **Target response time:** [DESIRED_RESPONSE_TIME]
- **Support team size:** [NUMBER_OF_SUPPORT_AGENTS]
- **Existing tools:** [LIST_SUPPORT_TOOLS, e.g., Zendesk, Intercom, Freshdesk]

Complete the following:

## 1. TICKET CLASSIFICATION ENGINE
- Design a multi-label classification system for incoming tickets covering category, urgency, sentiment, and complexity
- Define the classification taxonomy with primary categories, subcategories, and priority levels
- Create training examples showing 3 sample tickets for each category with expected classifications
- Build urgency detection rules based on keywords, customer tier, issue severity, and sentiment
- Design a routing matrix that maps classification results to the appropriate response workflow
- Include a confidence threshold system that auto-classifies high-confidence tickets and queues ambiguous ones for human triage

## 2. AUTOMATED RESPONSE SYSTEM
- Identify which ticket categories can be fully resolved by AI without human intervention
- Write response templates for each auto-resolvable category with personalization variables
- Design a dynamic FAQ matching system that pulls from the knowledge base to construct answers
- Create a step-by-step troubleshooting flow for the top 5 technical support categories
- Build response variation logic to avoid sending identical responses to the same customer
- Include a tone-matching system that adjusts formality based on the customer's writing style

## 3. ESCALATION FRAMEWORK
- Define escalation triggers: negative sentiment score, VIP customer flag, repeated contact within 24 hours, specific issue types, explicit agent request
- Design a tiered escalation path (Tier 1 AI, Tier 2 agent, Tier 3 specialist, Tier 4 management)
- Create context packaging that summarizes the conversation, attempted solutions, and customer sentiment for the receiving agent
- Build SLA timers for each escalation tier with automated reminders and breach alerts
- Define re-escalation rules for when a ticket bounces between tiers
- Design a warm handoff experience where the customer feels continuity, not repetition

## 4. KNOWLEDGE BASE INTEGRATION
- Map each ticket category to relevant knowledge base articles, internal docs, and past resolutions
- Design a semantic search layer that finds answers even when customers describe issues differently
- Create a knowledge gap detection system that flags recurring questions without good answers
- Build an auto-update workflow that creates draft knowledge base articles from successfully resolved novel issues
- Design a content freshness system that flags outdated articles based on product changes or customer feedback

## 5. QUALITY ASSURANCE AND MONITORING
- Define quality scoring criteria for AI responses: accuracy, helpfulness, tone, resolution completeness
- Design an automated QA sampling system that reviews a percentage of AI-handled tickets
- Create customer satisfaction prediction based on ticket interactions before sending a survey
- Build a real-time dashboard tracking: auto-resolution rate, average handle time, CSAT by channel, escalation rate, first-contact resolution
- Set up anomaly detection for sudden spikes in ticket volume, negative sentiment, or escalation rates
- Design weekly and monthly reporting templates for support leadership

## 6. CONTINUOUS IMPROVEMENT LOOP
- Create a feedback mechanism where agents rate AI suggestions and flag incorrect responses
- Design a monthly review of misclassified and poorly handled tickets to identify patterns
- Build a prompt refinement process based on accumulated feedback data
- Plan quarterly knowledge base audits driven by ticket trend analysis
- Define success benchmarks at 30, 60, and 90 days post-launch with specific metric targets
- Create an A/B testing framework for comparing response templates and classification models

Deliver the complete support system design as an implementation-ready document with all classification rules, response templates, escalation logic, and monitoring specifications. The output should enable a support operations team to configure their platform and begin the AI rollout within one week.

Be specific to my situation. No generic filler.
