---
name: ai-content-pipeline
description: Creates AI-assisted content production pipelines. Use when scaling content creation, building editorial workflows, or automating content repurposing.
metadata:
  category: ai-automation
  author: skillar
  version: "1.0"
---

# AI Content Pipeline

*Because AI-generated content without a human system produces AI-generated garbage.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete AI-assisted content production pipeline with stage-by-stage workflows, AI prompts for each step, quality checkpoints, and a repurposing strategy to maximize output from every piece of content.

## Instructions

You are a content operations strategist who has built AI-powered content pipelines for media companies and growth-stage startups. You understand how to leverage AI at every stage of content creation — from ideation to distribution — while maintaining brand voice, editorial standards, and SEO performance.

Given the following content context:
- **Content types produced:** [LIST_TYPES, e.g., blog posts, social media, newsletters, whitepapers, video scripts]
- **Publishing frequency goals:** [DESIRED_OUTPUT, e.g., 3 blog posts/week, daily social posts]
- **Target audience:** [DESCRIBE_AUDIENCE_DEMOGRAPHICS_AND_INTERESTS]
- **Brand voice:** [DESCRIBE_TONE_AND_STYLE, e.g., authoritative yet approachable, data-driven]
- **Current bottlenecks:** [DESCRIBE_WHERE_CONTENT_PRODUCTION_SLOWS_DOWN]
- **Team composition:** [WHO_IS_INVOLVED, e.g., 1 writer, 1 editor, 1 designer]
- **AI tools available:** [LIST_AI_TOOLS, e.g., ChatGPT, Jasper, Midjourney, Descript]

Complete the following:

## 1. PIPELINE ARCHITECTURE
- Design a stage-gate content pipeline with 5-7 stages from ideation to distribution
- Define the role of AI vs. human at each stage (AI drafts, human refines, AI optimizes)
- Map the handoff points between team members at each stage
- Estimate time per stage and total pipeline throughput per week
- Identify parallel tracks for different content types that share research or assets
- Create a visual pipeline flow description showing stages, owners, and time allocations

## 2. AI-POWERED IDEATION ENGINE
- Design a weekly ideation workflow that generates 20-30 content ideas using AI
- Create prompts for trend analysis based on industry keywords and competitor monitoring
- Build a content angle generator that takes one topic and produces 5 unique angles
- Design a headline and hook testing system using AI to evaluate engagement potential
- Create an editorial calendar template that balances evergreen, trending, and seasonal content
- Include a prompt for generating content briefs from approved ideas

## 3. CONTENT CREATION WORKFLOW
- Write stage-specific AI prompts for: research synthesis, outline generation, first draft, and section expansion
- Define the human editing pass requirements (fact-checking, voice alignment, originality check)
- Create a brand voice enforcement prompt that reviewers can use to check AI drafts
- Design a revision workflow for AI-human iteration loops (maximum 2 revision cycles)
- Build quality gates between draft and publish with specific pass/fail criteria
- Include prompts for generating meta descriptions, social snippets, and email subject lines from final content

## 4. CONTENT REPURPOSING SYSTEM
- Design a repurposing matrix showing how one pillar piece transforms into 5-10 derivative pieces
- Create AI prompts for converting blog posts to social threads, email newsletters, video scripts, and infographics
- Build a platform-specific adaptation workflow (adjust length, format, and tone per channel)
- Design a content atomization process that extracts standalone quotes, stats, and insights
- Create a scheduling template that staggers repurposed content across platforms over 2-4 weeks

## 5. QUALITY AND BRAND CONSISTENCY
- Define a content scoring rubric covering: accuracy, voice consistency, SEO optimization, readability, and engagement potential
- Create an AI-powered pre-publish checklist prompt that flags common issues
- Build a plagiarism and AI-detection review step using available tools
- Design a brand glossary and style guide reference system the AI uses for every piece
- Establish a monthly content audit process reviewing performance against quality scores

## 6. MEASUREMENT AND OPTIMIZATION
- Define 5 key content performance metrics aligned with business goals
- Create a weekly performance dashboard template showing output volume, engagement, and conversion metrics
- Design an AI-assisted post-mortem process for analyzing top and bottom performing content
- Build a feedback loop that feeds performance data back into the ideation engine
- Set quarterly pipeline optimization milestones with specific efficiency and quality targets

Deliver the complete pipeline as an operational playbook with every AI prompt ready to use, all workflow stages clearly defined, and the measurement framework in place. The output should enable a small content team to immediately double their output while maintaining or improving quality.

Be specific to my situation. No generic filler.
