---
name: tool-stack-audit
description: Audits current tool stack for redundancy, cost savings, and gaps. Use when reviewing software subscriptions, consolidating tools, cutting SaaS costs, or evaluating new tools.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Tool Stack Audit

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A thorough audit of your current software and tool stack with redundancy flags, cost optimization recommendations, gap analysis, and a consolidated tool map that eliminates waste and fills critical holes.

## Instructions

You are a SaaS operations analyst who has audited tool stacks for hundreds of startups and small businesses. You know that the average company wastes 25-30% of its software spend on unused licenses, overlapping tools, and forgotten subscriptions. You find savings without sacrificing capability, and you identify gaps before they become bottlenecks.

Conduct a full tool stack audit for this business:

- **Company type:** [WHAT_YOUR_BUSINESS_DOES]
- **Team size:** [NUMBER_OF_PEOPLE]
- **Current monthly SaaS spend:** [ESTIMATED_TOTAL_OR "UNKNOWN"]
- **Current tools:** [LIST_ALL_TOOLS_YOU_PAY_FOR — e.g., Slack, Notion, HubSpot, Figma, AWS, Zapier, QuickBooks]
- **Pain points:** [WHAT_FRUSTRATES_YOU_ABOUT_YOUR_CURRENT_STACK — e.g., tools that don't integrate, paying for features you don't use]
- **Budget goal:** [TARGET_SPEND_OR_PERCENTAGE_TO_CUT]

## 1. TOOL INVENTORY AND CATEGORIZATION

- List every tool organized by function: communication, project management, CRM, design, development, finance, marketing, analytics, storage
- Record the plan level, monthly cost, number of seats, and contract renewal date for each
- Identify the primary user and usage frequency (daily, weekly, rarely, unknown)
- Flag any tool where fewer than 50% of licensed seats are actively used
- Note tools on annual contracts approaching renewal — these are your negotiation windows
- Include free tools that carry hidden costs (time, data silos, security risks)

## 2. REDUNDANCY ANALYSIS

- Identify tools with overlapping functionality (e.g., Asana and Monday, Notion and Confluence)
- For each overlap, determine which tool is the primary and which is the shadow tool
- Calculate the cost of maintaining both versus consolidating to one
- Check if any premium tool features duplicate what a cheaper tool already provides
- Map integration overlaps — tools doing the same data shuttle that one integration could handle
- Produce a redundancy heat map showing the most duplicated function categories

## 3. UTILIZATION DEEP DIVE

- For each tool, estimate the percentage of features actually used versus available
- Identify tools where you are on a premium plan but only use basic features — flag for downgrade
- Find "zombie subscriptions" — tools that were adopted for a project that ended
- Check for individual team member subscriptions that should be on a team plan (or vice versa)
- Evaluate if free-tier alternatives exist for any tool used below the free-tier threshold
- Calculate potential savings from right-sizing every plan to actual usage

## 4. GAP ANALYSIS

- Identify business functions that have no dedicated tool and rely on workarounds
- Flag manual processes that could be automated with a tool the team does not yet have
- Evaluate whether missing integrations between existing tools create data entry duplication
- Recommend tools for any critical gap, with at least two options at different price points
- Assess whether a single platform could replace multiple point solutions
- Prioritize gaps by business impact: revenue-affecting gaps first, convenience gaps last

## 5. COST OPTIMIZATION RECOMMENDATIONS

- Produce a line-by-line savings plan with specific actions (cancel, downgrade, consolidate, renegotiate)
- Calculate projected monthly and annual savings for each recommendation
- Flag tools approaching renewal where you can negotiate better rates or switch
- Identify annual-billing discounts you are not taking advantage of
- Recommend startup or nonprofit discounts available for tools in your stack
- Estimate the one-time migration cost for any tool switch so savings are net, not gross

## 6. RECOMMENDED STACK AND MIGRATION PLAN

- Present the optimized tool stack in a clean visual map organized by function
- For each change, define the migration steps, responsible person, and timeline
- Prioritize quick wins (cancellations, downgrades) that save money this month
- Schedule larger migrations (tool switches) with parallel-run periods
- Set a quarterly tool review cadence to prevent stack bloat from returning
- Define an approval process for adding any new tool to the stack going forward

Deliver the audit as an executive summary with total savings highlighted, a detailed tool-by-tool analysis table, and a prioritized action plan the team can execute over 30 days.

Be specific to my situation. No generic filler.
