---
name: sop-builder
description: Creates a standard operating procedure for any recurring process. Use when documenting workflows, writing SOPs, standardizing processes, creating step-by-step guides, or building runbooks.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# SOP Builder

*Because tribal knowledge is a single point of failure wearing a lanyard.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete, ready-to-use standard operating procedure document with numbered steps, decision points, quality checks, and ownership assignments that any team member can follow without additional context.

## Instructions

You are a operations consultant who has built SOPs for hundreds of companies ranging from startups to Fortune 500s. You specialize in creating procedures that are clear enough for a new hire on day one yet rigorous enough to satisfy compliance audits. Your SOPs eliminate ambiguity and reduce tribal knowledge.

Create a comprehensive standard operating procedure for the following:

- **Process name:** [PROCESS_NAME]
- **Team/department:** [TEAM_OR_DEPARTMENT]
- **Current pain point:** [WHY_THIS_SOP_IS_NEEDED]
- **Frequency:** [HOW_OFTEN_THIS_RUNS — e.g., daily, weekly, per customer request]
- **Tools involved:** [TOOLS_OR_SYSTEMS_USED]
- **Audience skill level:** [BEGINNER / INTERMEDIATE / ADVANCED]

## 1. SOP HEADER AND METADATA

- Write a clear, specific title that identifies the process unambiguously
- Assign a document owner and list of approvers
- Set a review cadence (suggest quarterly or after every major incident)
- Define the scope — what this SOP covers and explicitly what it does not
- State the goal or success criteria for a properly executed run
- Include version number, effective date, and last-reviewed date

## 2. PREREQUISITES AND SETUP

- List every tool, login, permission, or access level needed before starting
- Identify any upstream processes or inputs that must be complete first
- Specify required materials, templates, or reference documents
- Note any environment or timing constraints (e.g., "must be done before 9 AM EST")
- Call out who to contact if a prerequisite is missing or blocked

## 3. STEP-BY-STEP PROCEDURE

- Number each step sequentially with a single clear action per step
- Include specific click paths, field names, or commands — never say "update the system"
- Add decision points with IF/THEN branching where the process may fork
- Embed screenshots placeholders or reference links for complex UI steps
- Mark estimated time per step or per section so the operator can plan
- Flag any step that requires a second pair of eyes or approval gate

## 4. QUALITY CHECKS AND VALIDATION

- Define what "done correctly" looks like at each critical milestone
- Include a final checklist the operator runs before marking the process complete
- Specify sample-check or spot-audit procedures for managers
- List the most common errors and how to catch them before they propagate
- State the acceptable error rate or tolerance threshold if applicable

## 5. ESCALATION AND EXCEPTION HANDLING

- Document the top 3-5 things that can go wrong and exact recovery steps
- Provide an escalation path with names/roles and response-time expectations
- Define when to stop the process entirely versus when to proceed with a workaround
- Include a "break glass" procedure for urgent or after-hours situations
- Specify how to log exceptions so they feed into the next SOP review

## 6. ROLES AND RESPONSIBILITIES (RACI)

- Assign Responsible, Accountable, Consulted, and Informed roles for the process
- Clarify handoff points between team members or departments
- Define backup personnel for each critical role
- State training requirements before someone can execute this SOP independently

## 7. REVISION AND CONTINUOUS IMPROVEMENT

- Set the review schedule and trigger events that force an immediate review
- Include a feedback mechanism for operators to flag unclear or outdated steps
- Define metrics to track SOP effectiveness (cycle time, error rate, completion rate)
- Provide a changelog template for documenting revisions

Format the entire SOP in clean markdown with numbered steps, bold key terms, and callout boxes for warnings. The document should be immediately usable — not a template about templates, but an actual working SOP ready for the team.

Be specific to my situation. No generic filler.
