---
name: remote-team-setup
description: Sets up remote team infrastructure with tools, processes, and communication norms. Use when going remote, hiring distributed teams, fixing remote culture, or setting up async workflows.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Remote Team Setup Guide

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete remote team infrastructure plan covering tool selection, communication protocols, meeting cadences, documentation standards, and culture-building practices that make distributed teams operate as well as co-located ones.

## Instructions

You are a remote operations architect who has built distributed team systems for companies ranging from 3-person startups to 200-person organizations. You know that remote work fails not because of distance but because of missing systems. Co-located teams paper over communication gaps with hallway conversations — remote teams need explicit infrastructure for what used to happen implicitly.

Design a remote team infrastructure for this team:

- **Company:** [COMPANY_NAME_AND_WHAT_IT_DOES]
- **Team size:** [NUMBER_OF_PEOPLE]
- **Time zones:** [TIMEZONE_SPREAD — e.g., US East to Europe, single timezone, global]
- **Current setup:** [FULLY_REMOTE / TRANSITIONING_FROM_OFFICE / HYBRID]
- **Biggest remote challenge:** [WHAT_IS_NOT_WORKING — e.g., communication gaps, isolation, slow decisions, meetings at bad hours]
- **Budget for tools:** [MONTHLY_BUDGET_FOR_SOFTWARE]
- **Team roles:** [TYPES_OF_ROLES — e.g., engineers, designers, sales, customer support]

## 1. COMMUNICATION ARCHITECTURE

- Define the communication stack with one tool per purpose: real-time chat, async discussion, video calls, announcements
- Create a channel strategy for the chat tool: what channels exist, naming conventions, and what goes where
- Set response-time norms by channel and urgency level (e.g., Slack DM: 4 hours, email: 24 hours, @urgent tag: 30 minutes)
- Establish "overlap hours" when all time zones are expected to be available for synchronous communication
- Design an escalation ladder: when to chat, when to call, when to page someone
- Create a "communication preferences" card each team member fills out (preferred contact method, working hours, focus blocks)

## 2. MEETING STRUCTURE

- Define the minimum viable meeting cadence: what recurring meetings the team actually needs
- Design each meeting type with purpose, attendees, duration, and async alternative
- Set meeting-free days or blocks to protect deep work across time zones
- Create a "no meeting without an agenda" policy with enforcement mechanisms
- Require recording for all meetings so async team members can catch up
- Build a "meeting cost calculator" — number of attendees times duration times hourly rate — to make time investment visible

## 3. DOCUMENTATION AND KNOWLEDGE MANAGEMENT

- Select a documentation platform and define the information architecture (handbook, wiki, project docs)
- Create a "write it down" culture: decisions, context, and reasoning get documented, not just outcomes
- Define documentation standards: templates, naming conventions, and ownership for each doc type
- Build an onboarding knowledge base that a new hire can self-serve through
- Set up a searchable decision log so anyone can find out why something was decided
- Establish a documentation review cadence to prevent knowledge rot

## 4. PROJECT AND TASK MANAGEMENT

- Select a project management tool and define how work flows through it (statuses, assignments, due dates)
- Create visibility standards: every team member should be able to see what everyone else is working on
- Define how handoffs work across time zones — the "end of day handoff" protocol
- Set up daily or weekly async standups (written format, not video) with a consistent template
- Build a "blocked" escalation process so no one waits 24 hours for an answer that takes 5 minutes
- Design sprint or weekly planning rituals adapted for async participation

## 5. CULTURE AND CONNECTION

- Schedule recurring social events that work across time zones (virtual coffee, show-and-tell, game sessions)
- Create non-work channels for hobbies, pets, random conversation — the digital water cooler
- Design a "virtual onboarding buddy" system for new hires who cannot learn by osmosis
- Build recognition practices: public shoutouts, peer appreciation, milestone celebrations
- Plan at least one annual or biannual in-person gathering if budget allows
- Run quarterly engagement pulse checks with 5 questions max and act visibly on feedback

## 6. SECURITY AND COMPLIANCE

- Define device and network security requirements for remote workers
- Set up VPN, SSO, and 2FA across all company tools
- Create a data handling policy for working from public spaces, shared homes, or co-working spaces
- Establish an equipment policy: what the company provides, stipend amounts, and reimbursement process
- Define an ergonomic workspace standard and provide a setup stipend
- Set expectations for physical workspace: camera-on norms, background requirements, noise standards

Deliver the plan as a "Remote Team Playbook" with a quick-start checklist for teams launching remote operations this week, a detailed infrastructure guide for full implementation, and a 90-day rollout timeline.

Be specific to my situation. No generic filler.
