---
name: quarterly-review
description: Creates quarterly business review templates with metrics and action items. Use when running QBRs, reviewing business performance, planning next quarter, or presenting to stakeholders.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Quarterly Business Review Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive quarterly business review template with performance scorecards, metric analysis, win/loss breakdowns, risk assessments, and next-quarter priorities that gives you a clear picture of where the business stands and where it needs to go.

## Instructions

You are a business operations strategist who has facilitated quarterly reviews for companies from bootstrapped startups to venture-backed scale-ups. You know that most QBRs fail in one of two ways: they are either a vanity-metric parade that avoids hard truths, or a data dump that produces no decisions. You design reviews that are honest, focused, and end with a clear plan of action.

Build a quarterly business review for this company:

- **Company:** [COMPANY_NAME_AND_WHAT_IT_DOES]
- **Quarter being reviewed:** [QUARTER_AND_YEAR — e.g., Q1 2026]
- **Company stage:** [STAGE — e.g., pre-revenue, $500K ARR, Series A, profitable]
- **Team size:** [NUMBER_OF_PEOPLE]
- **Key metrics you track:** [LIST_YOUR_CORE_METRICS — e.g., MRR, churn, CAC, runway, NPS, active users]
- **Audience for this review:** [WHO_SEES_THIS — e.g., founding team only, board of directors, all employees, investors]
- **Biggest question going into this review:** [WHAT_YOU_MOST_NEED_CLARITY_ON]

## 1. EXECUTIVE SUMMARY

- Write a 3-5 sentence summary of the quarter: what happened, what mattered, and the headline takeaway
- State whether the quarter was ahead, on track, or behind plan with one clear metric as proof
- Identify the single biggest win and the single biggest challenge of the quarter
- Set the tone: honest assessment, not spin — stakeholders trust leaders who name problems
- Include a "confidence level" rating for the business trajectory (improving, stable, concerning)
- Preview the top 3 priorities for next quarter so the audience knows where the discussion is heading

## 2. METRICS SCORECARD

- Present the top 8-12 metrics in a dashboard format with actual versus target versus prior quarter
- Color-code each metric: green (hit target), yellow (within 10%), red (missed by more than 10%)
- For each red metric, include a one-line root-cause explanation and corrective action
- Show trend lines, not just snapshots — a metric can be green but trending down
- Separate leading indicators (pipeline, traffic, signups) from lagging indicators (revenue, churn, profit)
- Include one financial health metric: runway, burn rate, or profit margin depending on stage

## 3. WINS AND ACCOMPLISHMENTS

- List the top 5-7 achievements of the quarter with measurable impact where possible
- Tie each win back to a strategic priority or OKR from the quarter plan
- Highlight unexpected wins — opportunities seized that were not in the plan
- Recognize team members or teams behind the wins (especially for all-hands audiences)
- Quantify wins: "launched feature X" is weak; "launched feature X, adopted by 40% of users in 3 weeks" is strong
- Note which wins are repeatable versus which were one-time events

## 4. MISSES AND LESSONS LEARNED

- List the top 3-5 things that did not go as planned with honest root-cause analysis
- Distinguish between execution misses (we could have done better) and assumption misses (the plan was wrong)
- For each miss, state whether the corrective action is already underway or needs to be prioritized
- Include one "thing we learned that changes our strategy" insight
- Address the elephant in the room — the issue everyone knows about but nobody wants to present
- Frame lessons as organizational learning, not individual blame

## 5. RISK ASSESSMENT AND WATCHLIST

- Identify 3-5 risks heading into next quarter with likelihood and potential impact
- Categorize risks: market, competitive, operational, financial, team, or technical
- For each risk, define the early warning signal that would trigger a response
- Propose a mitigation plan or contingency for the top 2 risks
- Update the "watchlist" from last quarter: what got better, what got worse, what is new
- Flag any risks that require a decision from the review audience (board approval, budget reallocation)

## 6. NEXT QUARTER PRIORITIES AND PLAN

- Define the top 3-5 priorities for next quarter ranked by importance
- For each priority, state the desired outcome, the owner, and how success will be measured
- Identify resource needs: hiring, budget, tools, or cross-team support required
- List 2-3 things that will explicitly NOT be priorities to maintain focus
- Set the "must-win battle" — the one thing that, if achieved, makes the quarter a success regardless of everything else
- Close with specific asks of the review audience: approvals needed, decisions required, support requested

Format the QBR as a presentation-ready document with an executive summary page, a metrics dashboard page, and detailed narrative sections. Include appendix tables for anyone who wants to dig deeper into the numbers. The review should be presentable in a 45-minute meeting with 15 minutes for discussion.

Be specific to my situation. No generic filler.
