---
name: onboarding-checklist
description: Creates employee or contractor onboarding checklists with first 30 days mapped out. Use when hiring new team members, building onboarding programs, creating first-week plans, or reducing new-hire ramp time.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Onboarding Checklist Builder

*Because a bad first week creates a bad first year.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured 30-day onboarding plan with day-by-day tasks, tool access setup, introduction schedules, learning milestones, and success checkpoints that gets new hires productive fast and makes them feel welcome from day one.

## Instructions

You are a people operations specialist who has designed onboarding programs that cut new-hire ramp time in half. You know that the first 30 days determine whether someone stays for 30 months. You build onboarding systems that balance information delivery with relationship building, because a new hire who knows every tool but knows nobody will still fail.

Create a comprehensive onboarding checklist for this situation:

- **Role being onboarded:** [JOB_TITLE]
- **Employment type:** [FULL-TIME_EMPLOYEE / CONTRACTOR / INTERN]
- **Team:** [TEAM_OR_DEPARTMENT]
- **Company size:** [NUMBER_OF_PEOPLE]
- **Work setup:** [REMOTE / HYBRID / IN-OFFICE]
- **Manager:** [MANAGER_NAME_AND_TITLE]
- **Start date:** [START_DATE]
- **Key tools they will use:** [LIST_OF_TOOLS — e.g., Slack, GitHub, Figma, Notion]

## 1. PRE-START PREPARATION (BEFORE DAY 1)

- List every account, tool, and access permission that must be provisioned before start date
- Draft a welcome email with first-day logistics, what to bring, and what to expect
- Assign an onboarding buddy who is not the direct manager
- Prepare hardware and equipment (laptop, monitors, peripherals) with setup instructions
- Pre-schedule the first week of meetings: manager 1:1, team intros, buddy coffee chats
- Create a shared onboarding document the new hire and manager can both track

## 2. DAY 1: WELCOME AND ORIENTATION

- Design the first-hour experience — who greets them, first conversation, workspace tour
- Walk through company mission, values, and how the team fits into the bigger picture
- Complete essential HR and admin tasks (payroll, benefits enrollment, security training)
- Set up all tools with guided walkthroughs, not just login credentials
- Share the team org chart with names, roles, and who to ask for what
- End day one with a casual team welcome (virtual or in-person)

## 3. WEEK 1: FOUNDATIONS AND CONTEXT

- Schedule 30-minute intro meetings with every key collaborator and stakeholder
- Provide a curated reading list of essential company documents (not a 200-page wiki dump)
- Assign a small, completable task that delivers a real win by end of week
- Walk through the team's current projects, priorities, and how work gets tracked
- Review communication norms: response time expectations, meeting culture, async etiquette
- Hold a Friday check-in to answer accumulated questions and adjust the plan

## 4. WEEKS 2-3: BUILDING COMPETENCE

- Assign progressively larger tasks that build skill and context simultaneously
- Pair on real work with experienced team members for hands-on learning
- Introduce the new hire to cross-functional partners they will work with regularly
- Review key processes and SOPs relevant to their role with practice runs
- Schedule a mid-point check-in with the manager to discuss pace, clarity, and concerns
- Encourage the new hire to document anything that was unclear — this improves onboarding for the next person

## 5. WEEK 4: INDEPENDENCE AND OWNERSHIP

- Transition from assigned tasks to self-directed work within team priorities
- Have the new hire lead a meeting, present work, or run a process independently
- Set 90-day goals collaboratively between the new hire and manager
- Conduct a formal 30-day review with structured feedback in both directions
- Identify any skill gaps that need targeted training or mentorship
- Celebrate the milestone — a shoutout in the team channel or a small recognition moment

## 6. ONGOING SUPPORT STRUCTURE

- Set recurring 1:1 cadence with the manager (weekly for the first 90 days)
- Define the 60-day and 90-day review checkpoints with evaluation criteria
- Create a "questions I still have" running document for the new hire
- Connect them to relevant learning resources, communities, or professional development
- Gather onboarding feedback through a structured survey to improve the process

Format the output as a day-by-day checklist for week one, then a week-by-week checklist for weeks two through four, with clear ownership (manager, buddy, new hire, IT) assigned to every task. Include a printable summary card with the top 10 things to complete before end of day one.

Be specific to my situation. No generic filler.
