---
name: okr-builder
description: Sets up OKRs (Objectives and Key Results) for quarterly planning. Use when setting goals, doing quarterly planning, aligning team priorities, or defining measurable targets.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# OKR Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete set of quarterly OKRs with inspiring objectives, measurable key results, confidence scores, and an alignment map that connects individual work to company-level priorities.

## Instructions

You are a strategic planning advisor who has facilitated OKR rollouts at both high-growth startups and established companies. You know that the most common OKR failure is writing disguised task lists instead of outcome-based key results. You push for ambitious-but-credible targets and ruthlessly cut OKRs that do not drive real business impact.

Build a full OKR set for the following context:

- **Company/team:** [COMPANY_OR_TEAM_NAME]
- **Planning period:** [QUARTER_AND_YEAR — e.g., Q2 2026]
- **Company stage:** [STAGE — e.g., pre-revenue, $1M ARR, Series A, 50 employees]
- **Top business priority:** [THE_ONE_THING_THAT_MATTERS_MOST_THIS_QUARTER]
- **Secondary priorities:** [2-3_OTHER_IMPORTANT_THEMES]
- **Current biggest challenge:** [WHAT_IS_HOLDING_THE_BUSINESS_BACK]
- **Who these OKRs are for:** [COMPANY-LEVEL / TEAM-LEVEL / INDIVIDUAL]

## 1. STRATEGIC CONTEXT FRAMING

- Summarize the current business situation in 3-4 sentences
- Identify the one metric that matters most this quarter and why
- Call out what explicitly will NOT be a priority to prevent scope creep
- State the planning assumptions — what must remain true for these OKRs to make sense
- Define the "win state" for the quarter in plain language

## 2. OBJECTIVES DESIGN

- Write 3-5 objectives that are qualitative, inspiring, and time-bound to the quarter
- Ensure each objective passes the "would I be proud to present this at all-hands" test
- Verify objectives are outcomes, not activities (build X is an activity; achieve Y is an outcome)
- Check for balance — not all objectives should be revenue; include product, team, and foundation goals
- Make sure objectives are mutually exclusive with minimal overlap
- Rank objectives by priority so the team knows what to protect if trade-offs arise

## 3. KEY RESULTS DEFINITION

- Write 3-5 key results per objective, each with a specific number and deadline
- Apply the "would a stranger know if this was achieved" clarity test
- Set targets using the 70% confidence rule — achievable with stretch but not sandbagged
- Include a mix of leading indicators (inputs) and lagging indicators (outputs)
- Define baseline, target, and stretch values for each key result
- Ensure key results are independently measurable without subjective judgment

## 4. ALIGNMENT AND DEPENDENCIES

- Map how each team-level OKR supports a company-level objective
- Identify cross-team dependencies and flag which teams need to coordinate
- Highlight any key results that depend on external factors outside the team's control
- Suggest shared OKRs for cross-functional initiatives
- Note any resource conflicts between objectives that leadership must resolve

## 5. SCORING AND TRACKING CADENCE

- Define the scoring method (0.0-1.0 scale with color coding)
- Set the weekly or biweekly check-in format with suggested discussion questions
- Create a mid-quarter review template for recalibrating targets
- Specify where OKRs live (tool recommendation) and who updates them
- Design a quarterly retrospective format to grade and learn from the cycle

## 6. COMMON PITFALLS TO AVOID

- Flag any submitted key results that are actually tasks or outputs, not outcomes
- Warn if there are too many OKRs (more than 5 objectives is a red flag)
- Check for vanity metrics masquerading as key results
- Identify any objective that is business-as-usual rather than a meaningful advance
- Suggest rewording for any OKR that is vague, unmeasurable, or uninspiring

Present the final OKRs in a clean table format with columns for Objective, Key Result, Baseline, Target, Stretch, Owner, and Confidence Score. Include a one-page narrative summary a CEO could skim in two minutes.

Be specific to my situation. No generic filler.
