---
name: meeting-agenda
description: Designs effective meeting agenda templates for different meeting types. Use when planning meetings, improving meeting culture, creating standup formats, or reducing wasted meeting time.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Meeting Agenda Designer

*Because a meeting without an agenda is just a group of people wasting time together.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A purpose-built meeting agenda template with timed sections, discussion prompts, decision frameworks, and follow-up structures that make meetings shorter, sharper, and actually worth having.

## Instructions

You are a meeting design consultant who believes most meetings should be emails and the ones that remain should be surgical. You have helped dozens of companies cut meeting time by 40% while improving decision quality. You design agendas that force clarity before the meeting starts and accountability after it ends.

Design a meeting agenda for this context:

- **Meeting type:** [TYPE — e.g., weekly team standup, project kickoff, 1:1, board meeting, sprint retrospective, all-hands, brainstorm, decision meeting]
- **Meeting purpose:** [THE_ONE_THING_THIS_MEETING_MUST_ACCOMPLISH]
- **Attendees:** [WHO_ATTENDS_AND_THEIR_ROLES — e.g., 5 engineers + product lead]
- **Duration:** [LENGTH_IN_MINUTES]
- **Cadence:** [ONE-TIME / WEEKLY / BIWEEKLY / MONTHLY / QUARTERLY]
- **Current problem:** [WHAT_IS_WRONG_WITH_HOW_THIS_MEETING_RUNS_TODAY]

## 1. MEETING NECESSITY CHECK

- State the meeting's purpose in one sentence — if you cannot, it should not be a meeting
- Define what type of meeting this is: decision, information sharing, brainstorm, or alignment
- List what would happen if this meeting were cancelled — if "nothing bad," cancel it
- Identify which attendees are essential versus optional (mark optional attendees clearly)
- Determine if async alternatives could serve part of the purpose (pre-read, Loom, shared doc)
- Set a "this meeting earns its existence by producing ___" accountability statement

## 2. PRE-MEETING PREPARATION

- Define what every attendee must prepare or review before the meeting
- Create a pre-read document template with a strict length limit (one page maximum)
- Set a deadline for pre-read distribution (24-48 hours before the meeting)
- List specific questions attendees should come prepared to answer
- Designate a facilitator and a note-taker for each meeting instance
- Share the agenda at least 24 hours in advance with time blocks visible

## 3. AGENDA STRUCTURE AND TIMING

- Open with a 2-minute context reset: purpose, desired outcome, and ground rules
- Allocate specific minutes to each agenda item — not "time permitting"
- Front-load decisions and high-energy items before attention fades
- Include a "parking lot" section for important-but-off-topic items
- Build in 5 minutes of buffer for a 30-minute meeting, 10 for a 60-minute meeting
- Close with a 3-minute action-item review: who does what by when

## 4. DISCUSSION FRAMEWORKS

- Provide facilitator prompts that keep conversation on track without being rigid
- Include a decision-making protocol for when the group gets stuck (e.g., RAPID, consultative, majority)
- Design a "round-robin" or "silent writing" technique to prevent loudest-voice-wins dynamics
- Set a "two-minute rule" for individual contributions to prevent monologues
- Create escalation criteria for topics that need more time — schedule a follow-up instead of overrunning
- Add a "disagree and commit" protocol for decisions that lack consensus

## 5. ACTION ITEMS AND FOLLOW-UP

- Define the action-item format: owner, deliverable, deadline (not "let's circle back")
- Specify where action items are recorded and who is responsible for distributing notes
- Set a follow-up cadence for checking on action items before the next meeting
- Include a "decisions made" log so absent team members know what was resolved
- Create a 24-hour rule: meeting notes distributed within one business day

## 6. CONTINUOUS IMPROVEMENT

- Add a 60-second meeting rating at the end (thumbs up/down or 1-5 score)
- Review meeting effectiveness monthly: are decisions being made, are action items completing
- Set a quarterly "meeting audit" to kill, merge, or shorten underperforming meetings
- Track total meeting hours per team member per week as a health metric
- Establish a "meeting-free" block policy to protect deep work time

Deliver the agenda as a copy-paste-ready template with time stamps, facilitator scripts, and a companion one-page meeting rules card that can be pinned in the team's Slack channel or meeting room.

Be specific to my situation. No generic filler.
