---
name: incident-response
description: Creates incident response plans for outages, security issues, and PR crises. Use when preparing for emergencies, building runbooks, handling downtime, or managing security breaches.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Incident Response Plan Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A battle-ready incident response plan with severity classifications, escalation paths, communication templates, role assignments, and post-incident review processes that turn chaos into coordinated action when things go wrong.

## Instructions

You are an incident management specialist who has led response teams through outages, security breaches, data losses, and PR crises. You know that incidents are not prevented by plans — they are prevented by practice. But when prevention fails, the difference between a minor hiccup and a company-ending disaster is how fast and how well the team responds. You build plans that work at 2 AM when everyone is stressed and half-awake.

Create an incident response plan for this organization:

- **Company:** [COMPANY_NAME_AND_WHAT_IT_DOES]
- **Team size:** [NUMBER_OF_PEOPLE]
- **Product/service type:** [WHAT_COULD_GO_DOWN — e.g., SaaS platform, e-commerce store, API service, physical product]
- **Customer base:** [NUMBER_AND_TYPE_OF_CUSTOMERS]
- **Biggest risk areas:** [TOP_CONCERNS — e.g., server outages, data breach, payment failures, negative press, supply chain disruption]
- **Current incident process:** [WHAT_HAPPENS_TODAY_WHEN_SOMETHING_BREAKS — or "nothing formal"]
- **On-call setup:** [CURRENT_ON-CALL_ROTATION_OR "NONE"]

## 1. INCIDENT CLASSIFICATION

- Define 4 severity levels with clear, objective criteria for each (SEV1: customer-facing outage, SEV2: degraded service, SEV3: internal disruption, SEV4: minor issue)
- For each severity level, specify the response time target and who must be notified
- Create a quick-reference decision tree: "If X is happening, this is a SEV ___"
- Include examples of past or hypothetical incidents at each severity level
- Define what constitutes an "all hands on deck" situation versus a "handle during business hours" issue
- Clarify who has authority to declare an incident and escalate the severity level

## 2. ROLES AND RESPONSIBILITIES

- Define the Incident Commander role: who leads, what authority they have, how they are selected
- Assign a Communications Lead responsible for all internal and external messaging
- Designate a Technical Lead who owns diagnosis and resolution
- Create an on-call rotation schedule with primary and secondary responders
- Define the "war room" protocol: who joins, where they gather (virtual channel or bridge line), and ground rules
- Specify backup personnel for every critical role so no single person is a point of failure

## 3. RESPONSE PROCEDURES BY INCIDENT TYPE

- Build a step-by-step runbook for each major incident type (outage, data breach, security vulnerability, PR crisis, payment system failure)
- Include the first 15 minutes checklist — the critical actions before full team assembly
- Define the investigation process: how to diagnose root cause while simultaneously mitigating impact
- Specify when to engage external help (security firms, legal counsel, PR agencies) and pre-negotiate contacts
- Include rollback and failover procedures for technical incidents
- Create customer-facing workaround instructions to reduce support volume during incidents

## 4. COMMUNICATION PROTOCOLS

- Draft templates for each severity level: internal Slack announcement, customer email, status page update, social media post
- Define the communication cadence: how often updates go out during an active incident (every 30 minutes for SEV1)
- Specify who approves external communications and the maximum review time (10 minutes, not 2 hours)
- Create a stakeholder notification matrix: who gets told what, how, and in what order
- Prepare holding statements for common scenarios so the first message goes out in minutes, not hours
- Define the "no surprises" rule: leadership and customer-facing teams hear about incidents before customers do

## 5. RESOLUTION AND RECOVERY

- Define "resolved" versus "mitigated" versus "monitoring" states with clear transition criteria
- Create a resolution verification checklist before declaring an incident closed
- Specify the monitoring period after resolution (e.g., 24 hours of elevated alerting)
- Design a customer follow-up process: apology, explanation, compensation if warranted
- Document the timeline of events while memory is fresh (within 24 hours of resolution)
- Trigger a post-incident review for any SEV1 or SEV2 incident

## 6. POST-INCIDENT REVIEW AND PREVENTION

- Schedule a blameless post-mortem within 48 hours of incident resolution
- Use a structured format: timeline, root cause, contributing factors, what went well, what to improve
- Require concrete action items with owners and deadlines — not vague "we should do better"
- Track action item completion and review at the next team meeting
- Maintain an incident log that reveals patterns over time (recurring causes, frequent failure points)
- Run quarterly tabletop exercises to practice the plan before the next real incident hits

Deliver the plan as an executive summary for leadership, a detailed response playbook for the on-call team, and a set of laminated-card-style quick-reference guides for the first 15 minutes of each incident type.

Be specific to my situation. No generic filler.
