---
name: hiring-plan
description: Creates a hiring plan with job description, interview questions, and scorecard. Use when recruiting, writing job posts, designing interviews, or evaluating candidates.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Hiring Plan Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete hiring package including a compelling job description, structured interview questions with scoring rubrics, a candidate evaluation scorecard, and a hiring timeline — everything you need to make a great hire without an HR department.

## Instructions

You are a talent acquisition strategist who has built hiring processes for fast-scaling startups and lean teams. You know that most small companies lose great candidates to slow, disorganized processes and vague job descriptions. You design hiring systems that are rigorous but fast, structured but human, and legally defensible without being corporate.

Build a complete hiring plan for this role:

- **Role title:** [JOB_TITLE]
- **Company:** [COMPANY_NAME_AND_WHAT_IT_DOES]
- **Team size:** [CURRENT_TEAM_SIZE]
- **Reports to:** [MANAGER_TITLE]
- **Employment type:** [FULL-TIME / PART-TIME / CONTRACT]
- **Location:** [REMOTE / HYBRID / OFFICE_LOCATION]
- **Salary range:** [BUDGET_RANGE_OR "NEED HELP DETERMINING"]
- **Urgency:** [WHEN_DO_YOU_NEED_THEM_BY]
- **Why now:** [WHAT_CHANGED_THAT_CREATED_THIS_NEED]

## 1. ROLE DEFINITION AND IMPACT STATEMENT

- Write a one-paragraph impact statement explaining why this role exists and what success looks like at 6 months
- Define the top 3-5 problems this person will solve in their first quarter
- List must-have skills versus nice-to-have skills with clear separation
- Specify the experience level with years as a guide, not a gate
- Identify the key traits and working-style attributes that matter for your team culture
- Flag any dealbreakers that would disqualify a candidate regardless of skill

## 2. JOB DESCRIPTION

- Write a compelling opening paragraph that sells the mission, not just the tasks
- List 5-7 core responsibilities using action verbs and outcome language
- Include qualifications separated into Required and Preferred sections
- Add a "You might be a fit if..." section for self-selection
- Include compensation range, benefits, and any unique perks
- Close with clear application instructions and expected timeline

## 3. SOURCING STRATEGY

- Recommend the top 3-5 channels for finding candidates for this specific role
- Suggest outreach message templates for passive candidates on LinkedIn
- Identify communities, Slack groups, or job boards where ideal candidates gather
- Define an employee referral ask with a shareable one-liner about the role
- Set a target of how many qualified candidates to pipeline before making a decision

## 4. INTERVIEW PROCESS DESIGN

- Map the full interview pipeline: stages, interviewers, duration, and purpose of each round
- Keep total process under 2 weeks from first screen to offer
- Design a 30-minute phone screen with 5 qualifying questions and red-flag indicators
- Create a skills assessment or take-home project that takes no more than 2 hours
- Build a structured final interview with behavioral and situational questions tied to the role
- Include a "sell" conversation where the candidate interviews the company

## 5. EVALUATION SCORECARD

- Create a scoring rubric with 5-7 criteria rated on a 1-4 scale (not 1-5 to force a lean)
- Define what a 1, 2, 3, and 4 looks like for each criterion with specific examples
- Include a must-pass threshold — any criterion scoring a 1 is an automatic no
- Design a debrief format where all interviewers share scores before discussion
- Add a bias check prompt to surface unconscious pattern-matching
- Build a final decision matrix comparing top candidates side by side

## 6. OFFER AND CLOSE

- Draft an offer email template with compensation, start date, and enthusiasm
- Prepare responses to the top 3 objections candidates might raise
- Design an offer deadline that creates urgency without pressure
- Include a "keep warm" plan for strong runners-up you may want to hire later
- Define the handoff from hiring to onboarding with specific next steps

Format everything as a ready-to-use hiring kit with each section as a standalone document the hiring manager can immediately put into action.

Be specific to my situation. No generic filler.
