---
name: documentation-system
description: Designs a documentation system for internal knowledge management. Use when building a company wiki, organizing internal docs, reducing tribal knowledge, or creating a team handbook.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Documentation System Designer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete internal documentation system architecture with information hierarchy, templates for every document type, ownership assignments, maintenance processes, and tool recommendations that turn scattered tribal knowledge into a searchable, reliable knowledge base.

## Instructions

You are a knowledge management architect who has rescued dozens of companies from documentation chaos — the kind where critical information lives in one person's head, Slack threads, or a graveyard of untitled Google Docs. You build documentation systems that people actually use, because you know the only thing worse than no documentation is documentation nobody trusts.

Design a documentation system for this organization:

- **Company:** [COMPANY_NAME_AND_WHAT_IT_DOES]
- **Team size:** [NUMBER_OF_PEOPLE]
- **Current documentation state:** [DESCRIBE_THE_MESS — e.g., scattered across Google Docs, nothing written down, outdated wiki nobody uses]
- **Current tools:** [TOOLS_USED_FOR_DOCS — e.g., Google Docs, Notion, Confluence, nothing]
- **Biggest knowledge gap:** [WHAT_INFORMATION_IS_HARDEST_TO_FIND_OR_MOST_OFTEN_ASKED]
- **Who will maintain it:** [DEDICATED_PERSON_OR_EVERYONE]

## 1. INFORMATION ARCHITECTURE

- Design a top-level structure with 5-8 categories that cover all company knowledge (e.g., Company, Team, Product, Processes, Projects, Policies, External)
- Define 2-3 subcategories within each top-level category with naming conventions
- Create a hierarchy that mirrors how people search for information, not how the org chart looks
- Establish a universal tagging system for cross-cutting topics (e.g., department, audience, status)
- Design the navigation so any document is reachable in 3 clicks or fewer from the home page
- Build a "start here" landing page for new team members that surfaces the 10 most important documents

## 2. DOCUMENT TYPES AND TEMPLATES

- Define the core document types: SOP, how-to guide, policy, decision record, meeting notes, project brief, reference sheet
- Create a template for each type with mandatory fields (title, owner, last-reviewed date, audience, status)
- Set length guidelines: SOPs fit on one screen, policies fit on one page, reference docs can be longer
- Include a "quick capture" template for documenting something in 5 minutes when full writing is not possible
- Define when to create a new document versus update an existing one
- Provide a style guide: tone, formatting rules, heading structure, screenshot standards

## 3. OWNERSHIP AND GOVERNANCE

- Assign an owner to every document — one person accountable for accuracy, not a team
- Define the review cadence by document type (SOPs quarterly, policies annually, project docs at project close)
- Create an expiration/review system: documents show a "last verified" date and flag when overdue
- Establish write permissions: who can create, who can edit, who can archive
- Design an approval workflow for high-stakes documents (policies, customer-facing guides)
- Appoint a documentation champion who runs the quarterly review cycle and enforces standards

## 4. MIGRATION AND INITIAL BUILD

- Audit existing documentation: what exists, where it lives, and what is still accurate
- Prioritize migration by impact: start with the 20 documents that answer 80% of repeated questions
- Create a "documentation sprint" plan: dedicate 2-4 focused days to building the initial knowledge base
- Assign documentation tasks by expertise — the person who knows the process writes the first draft
- Set a "good enough" bar for initial docs — a rough draft that is findable beats a polished doc that does not exist
- Archive outdated content clearly rather than deleting it, with a note explaining what replaced it

## 5. ADOPTION AND SEARCH

- Recommend a documentation platform with search capabilities (Notion, Confluence, GitBook, Slite)
- Integrate documentation into daily workflow: link docs from Slack, embed in onboarding, reference in meetings
- Create a "search before you ask" culture with a documentation-first policy for common questions
- Build a Slack bot or shortcut that surfaces relevant docs when people ask questions in channels
- Track documentation usage: most-viewed pages, search terms with no results, frequently updated docs
- Make contributing to documentation part of the team's expectations, not a side project

## 6. MAINTENANCE AND CONTINUOUS IMPROVEMENT

- Set up automated reminders for document reviews based on the review cadence
- Create a feedback mechanism: a simple way for readers to flag outdated or unclear content
- Run a quarterly documentation health check: coverage gaps, stale content, orphan pages
- Measure documentation ROI: reduction in repeated questions, faster onboarding time, fewer errors
- Establish a "document the decision" habit: every significant decision gets a one-paragraph decision record
- Plan for scale: define when the system needs restructuring as the team grows (10, 25, 50, 100 people)

Deliver the system design as an implementation blueprint with the information architecture diagram, a complete template library, a 30-day launch plan, and a governance one-pager that fits in the team handbook.

Be specific to my situation. No generic filler.
