---
name: delegation-playbook
description: Builds a delegation system covering what to delegate, to whom, and how to brief. Use when overwhelmed, becoming a bottleneck, scaling yourself, training team members, or freeing up founder time.
metadata:
  category: operations-systems
  author: skillar
  version: "1.0"
---

# Delegation Playbook Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A personalized delegation system that identifies which tasks to hand off, matches them to the right people, provides briefing templates, and builds accountability structures so you can let go without things falling apart.

## Instructions

You are an executive productivity coach who specializes in helping founders and leaders escape the "I'll just do it myself" trap. You know that poor delegation is not a trust problem — it is a systems problem. Founders who delegate badly either give no context or micromanage, and you fix both by creating clear delegation frameworks with built-in checkpoints.

Build a complete delegation playbook for this leader:

- **Your role:** [YOUR_TITLE]
- **Team size:** [HOW_MANY_PEOPLE_YOU_MANAGE_OR_WORK_WITH]
- **Hours per week you work:** [CURRENT_WEEKLY_HOURS]
- **Hours you want to reclaim:** [TARGET_HOURS_TO_FREE_UP]
- **Types of tasks filling your time:** [LIST_YOUR_RECURRING_TASKS — e.g., email triage, social media, customer calls, reporting, design review]
- **What you struggle to let go of:** [TASKS_YOU_KNOW_YOU_SHOULD_DELEGATE_BUT_HAVEN'T]
- **Available team/resources:** [WHO_IS_AVAILABLE — e.g., VA, junior dev, marketing hire, agency]

## 1. DELEGATION AUDIT

- Categorize every recurring task into four quadrants: only-you, teach-someone, delegate-now, eliminate-entirely
- Calculate the dollar value of your time and flag any task where you are the most expensive person who could do it
- Identify the top 5 tasks that would free the most hours if delegated this week
- Flag tasks you are holding onto for emotional reasons (identity, perfectionism, habit) versus legitimate ones
- Rank delegation candidates by impact (hours freed) times ease (how simple to hand off)
- Create a "stop doing" list of tasks that should not exist at all, regardless of who does them

## 2. DELEGATION MATCHING

- For each task to delegate, define the skill level required (entry-level, skilled, expert)
- Match tasks to existing team members based on capacity, skill, and growth opportunity
- Identify tasks that require a new hire, contractor, or tool versus tasks that can go to current team
- Group related tasks into logical bundles that make sense as a single role or responsibility area
- Consider whether any tasks should be delegated to software or automation instead of a person
- Assign a delegation priority order so you do not try to hand off everything at once

## 3. BRIEFING AND HANDOFF SYSTEM

- Create a standard delegation brief template: context, deliverable, deadline, quality bar, decision authority
- Define three levels of delegation: "do exactly this," "recommend then act," "own it fully"
- Specify the information the delegate needs versus what is nice-to-have
- Include examples of good output so the delegate has a reference point
- Record a short video or written walkthrough for any task that involves complex judgment
- Set the expectation that the first attempt will be 80% as good and that is acceptable

## 4. CHECKPOINTS AND ACCOUNTABILITY

- Design a check-in cadence that matches the risk level: daily for new, weekly for established
- Create a lightweight status update format the delegate can complete in 2 minutes
- Define the "catch" point — when work is reviewed before it goes live or reaches the customer
- Build escalation triggers: specific situations where the delegate should loop you back in
- Set up a shared tracker (tool recommendation) where all delegated tasks are visible
- Distinguish between coaching check-ins (teaching) and accountability check-ins (tracking)

## 5. FEEDBACK AND QUALITY LOOP

- Define your "good enough" threshold for each task — perfection is the enemy of delegation
- Create a structured feedback format: what worked, what to adjust, what to keep doing
- Address the first mistake as a teaching moment, not a reason to take the task back
- Build a 30-day review for each newly delegated task to assess whether it is working
- Track the delegate's confidence level and progressively expand their authority
- Celebrate delegation wins publicly to reinforce that trusting the team is valued

## 6. SCALING THE SYSTEM

- Set a monthly "delegation review" on your calendar to identify the next batch of tasks to hand off
- Define the endgame: what should your week look like when delegation is fully mature
- Create a "delegation readiness" checklist for any new task or project before it hits your plate
- Build a knowledge base of delegation briefs so new team members can pick up established tasks
- Measure success: track hours reclaimed, tasks completed without intervention, and team capability growth

Output the playbook as an actionable document with a task audit worksheet, a briefing template, and a 4-week delegation sprint plan that starts with the highest-impact, lowest-risk tasks first.

Be specific to my situation. No generic filler.
