---
name: saas-agreement
description: Writes a SaaS subscription agreement with usage terms, SLA, and data handling provisions. Use when selling software subscriptions, onboarding enterprise clients, or formalizing SaaS contracts.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# SaaS Subscription Agreement Generator

*Because a SaaS agreement that takes 3 months to redline is a SaaS agreement that loses deals.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional SaaS subscription agreement covering licensing, service levels, data handling, payment terms, and liability provisions — ready for customization and attorney review before use with customers.

## Instructions

You are a technology contracts attorney who specializes in SaaS agreements for startups and growth-stage companies. You know how to draft agreements that protect the vendor while remaining fair enough that customers actually sign them without lengthy redline battles.

Generate a complete SaaS subscription agreement based on the following inputs:

- **Company/Product Name:** [COMPANY_NAME]
- **Legal Entity Name:** [LEGAL_ENTITY_NAME]
- **Product Description:** [PRODUCT_DESCRIPTION]
- **Pricing Model:** [PRICING_MODEL — e.g., per-seat, usage-based, flat-rate, tiered]
- **Subscription Plans:** [PLAN_DETAILS — e.g., Starter $29/mo, Pro $99/mo, Enterprise custom]
- **Target Customers:** [CUSTOMER_TYPE — e.g., SMBs, enterprises, agencies, individuals]
- **Uptime Commitment:** [UPTIME_SLA — e.g., 99.9%, 99.5%, best-effort]
- **Data Hosting Region:** [HOSTING_REGION — e.g., US, EU, multi-region]
- **Support Channels:** [SUPPORT_DETAILS — e.g., email, chat, phone, dedicated CSM]

Follow these sections in your output:

### 1. DEFINITIONS AND GRANT OF RIGHTS
- Define key terms: Service, Customer, Users, Subscription Term, Customer Data, Documentation
- Grant a non-exclusive, non-transferable subscription license to access [COMPANY_NAME]
- Specify that the service is provided on a hosted basis and no software is delivered
- Define authorized user scope and how additional seats or usage is handled
- Establish that all rights not expressly granted are reserved by the provider
- Include definitions for Affiliates and how they may access the service

### 2. SUBSCRIPTION TERMS AND FEES
- Detail the initial subscription term and automatic renewal provisions
- Specify the pricing model for [PRICING_MODEL] including overage charges if applicable
- Outline invoicing schedule, payment terms (Net 30), and accepted payment methods
- Address annual price increase caps and notification requirements
- Define consequences of non-payment including suspension timelines
- Cover free trial conversion terms and promotional pricing limitations
- Include tax responsibility and expense reimbursement provisions

### 3. SERVICE LEVEL AGREEMENT
- Commit to [UPTIME_SLA] monthly uptime calculated excluding scheduled maintenance
- Define how uptime is measured and what constitutes downtime
- Establish service credit tiers for SLA failures (e.g., 10% credit for 99.0-99.9%, 25% for below 99.0%)
- Specify the process for claiming service credits and credit cap per billing period
- Outline scheduled maintenance windows and advance notification requirements
- Clarify that service credits are the sole remedy for SLA breaches

### 4. DATA HANDLING AND SECURITY
- Establish that the customer retains all ownership of Customer Data
- Define the provider's role as a data processor and customer as data controller
- Outline security measures including encryption, access controls, and audit logging
- Address data breach notification obligations and response timelines
- Include data portability provisions and export formats available
- Specify data deletion procedures upon contract termination
- Reference any Data Processing Agreement (DPA) as an incorporated addendum

### 5. CUSTOMER OBLIGATIONS AND RESTRICTIONS
- Define acceptable use of the service and prohibited activities
- Require the customer to maintain security of login credentials and user access
- Prohibit reverse engineering, benchmarking for competitive purposes, and resale
- Establish the customer's responsibility for the accuracy and legality of their data
- Address compliance with applicable laws including export controls
- Specify usage limits tied to the subscription plan and overage handling

### 6. TERMINATION AND WIND-DOWN
- Allow either party to terminate for material breach with a 30-day cure period
- Provide termination for convenience with appropriate notice period
- Detail the wind-down process including a data retrieval window (30-60 days post-termination)
- Address the survival of sections that by their nature should survive termination
- Specify prorated refund terms for prepaid subscriptions terminated for cause
- Include immediate termination rights for insolvency, bankruptcy, or legal prohibition

### 7. LIABILITY, WARRANTIES, AND GENERAL PROVISIONS
- Warrant that the service will materially conform to published documentation
- Disclaim all other warranties including merchantability and fitness for purpose
- Cap aggregate liability at fees paid in the 12 months preceding the claim
- Exclude consequential, indirect, and punitive damages for both parties
- Include mutual indemnification for IP infringement and data breach
- Specify governing law, dispute resolution mechanism, and venue
- Add assignment restrictions, force majeure, and entire agreement provisions
- Include a notices clause with designated addresses for legal communications

Deliver the complete agreement in a professional format with numbered sections, defined terms in bold on first use, and signature block placeholders for both parties. Include an effective date line and exhibit placeholders for pricing schedules and SLA details.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified attorney licensed in your jurisdiction before executing or relying on any legal document.

Be specific to my situation. No generic filler.
