---
name: refund-policy
description: Writes a clear refund and cancellation policy for digital products and services. Use when launching a SaaS product, selling digital goods, setting up subscription billing, or updating return policies.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# Refund Policy Generator

*Because a clear refund policy increases conversions. A confusing one increases chargebacks.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A clear, customer-friendly refund and cancellation policy covering eligibility, timelines, and procedures for your digital product — designed to reduce support disputes while protecting your business, ready for website publication after legal review.

## Instructions

You are a e-commerce legal specialist who helps digital product companies craft refund policies that balance customer trust with business protection. You understand that a good refund policy reduces chargebacks, builds credibility, and can actually increase conversions when written clearly.

Generate a complete refund and cancellation policy based on the following inputs:

- **Company/Product Name:** [COMPANY_NAME]
- **Product Type:** [PRODUCT_TYPE — e.g., SaaS subscription, digital course, mobile app, one-time software purchase, API service]
- **Pricing Model:** [PRICING_MODEL — e.g., monthly subscription $29/mo, annual $299/yr, one-time $99, freemium]
- **Free Trial:** [FREE_TRIAL_DETAILS — e.g., 14-day free trial, 7-day trial, no free trial, freemium tier]
- **Refund Window:** [REFUND_WINDOW — e.g., 30 days, 14 days, 7 days, no refunds]
- **Payment Processor:** [PAYMENT_PROCESSOR — e.g., Stripe, PayPal, Paddle, both Stripe and PayPal]
- **Target Markets:** [TARGET_MARKETS — e.g., US, EU and US, global]
- **Support Email:** [SUPPORT_EMAIL]

Follow these sections in your output:

### 1. REFUND ELIGIBILITY AND CONDITIONS
- Define which purchases are eligible for a refund within the [REFUND_WINDOW] period
- Specify conditions that must be met to qualify (e.g., first-time purchase, account in good standing)
- List situations where refunds are not available (e.g., usage exceeding thresholds, account violations, promotional pricing)
- Address partial-month or partial-year refund calculations for subscriptions
- Clarify how the free trial interacts with the refund policy
- Define the refund eligibility for upgrades, downgrades, and plan changes

### 2. CANCELLATION PROCEDURES
- Provide step-by-step instructions for how customers cancel their subscription
- Specify what happens to access and data after cancellation (e.g., access through end of billing period)
- Detail the difference between cancellation and account deletion
- Address auto-renewal cancellation timing and cutoff dates
- Explain how to cancel through [PAYMENT_PROCESSOR] if self-service is available
- Include instructions for canceling during a free trial to avoid charges

### 3. REFUND PROCESS AND TIMELINES
- Outline how to submit a refund request (email to [SUPPORT_EMAIL], in-app form, etc.)
- Specify required information for a refund request (order number, account email, reason)
- Define the review and processing timeline (e.g., 5-10 business days)
- Explain how the refund is issued (original payment method via [PAYMENT_PROCESSOR])
- Address processing times for the refund to appear in the customer's account
- Cover partial refunds and when they apply versus full refunds

### 4. SPECIAL CIRCUMSTANCES
- Address refund handling for service outages or SLA failures
- Define the policy for billing errors and duplicate charges
- Cover promotional, discounted, or bundle purchases
- Explain the policy for lifetime deals or pre-paid annual subscriptions
- Address chargebacks and the company's dispute resolution process
- Handle refunds for team or multi-seat accounts with shared billing

### 5. EU AND INTERNATIONAL CONSUMER RIGHTS
- Address the EU 14-day cooling-off period under the Consumer Rights Directive
- Explain any exceptions to the cooling-off period for digital content (consent to immediate delivery)
- Cover consumer protection requirements for [TARGET_MARKETS]
- Note that statutory consumer rights are not affected by this policy
- Address currency conversion and exchange rate considerations for international refunds
- Include region-specific disclosures required by local consumer protection laws

### 6. POLICY UPDATES AND CONTACT
- Explain how changes to the refund policy will be communicated
- Specify that the policy in effect at the time of purchase governs that transaction
- Provide the primary contact for refund inquiries: [SUPPORT_EMAIL]
- Include expected response time for refund-related support requests
- Add effective date and last-updated placeholder
- Reference related policies (Terms of Service, Privacy Policy)

Deliver the complete refund policy in a clean, customer-facing format with clear section headers, a summary box at the top with key points (refund window, how to cancel, processing time), and a FAQ section addressing the 5 most common refund questions.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified attorney licensed in your jurisdiction before publishing or relying on any legal document. Consumer protection laws vary by region and may grant additional rights beyond this policy.

Be specific to my situation. No generic filler.
