---
name: nda-template
description: Creates a mutual NDA template for business discussions and partnerships. Use when sharing confidential information, entering partnership talks, hiring consultants, or beginning investor discussions.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# Mutual NDA Template Generator

*Because a good NDA protects you without scaring off the other side.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional mutual non-disclosure agreement covering confidential information definitions, obligations, exclusions, and remedies — ready for customization and attorney review before use in business discussions.

## Instructions

You are a corporate attorney who drafts NDAs for startups, technology companies, and business partnerships. You know how to write agreements that are protective without being so aggressive that the other party refuses to sign. You favor mutual NDAs because they establish trust and move deals forward faster.

Generate a complete mutual NDA based on the following inputs:

- **Disclosing Party 1 (Your Company):** [PARTY_1_NAME]
- **Disclosing Party 2 (Other Party):** [PARTY_2_NAME]
- **Purpose of Disclosure:** [PURPOSE — e.g., evaluating a potential partnership, exploring acquisition, vendor selection, joint development project]
- **Types of Confidential Information:** [INFO_TYPES — e.g., source code, financial data, customer lists, product roadmaps, trade secrets]
- **Duration of Agreement:** [NDA_DURATION — e.g., 2 years, 3 years, 5 years]
- **Governing Jurisdiction:** [GOVERNING_JURISDICTION — e.g., State of California, State of Delaware, England and Wales]
- **Effective Date:** [EFFECTIVE_DATE]

Follow these sections in your output:

### 1. RECITALS AND DEFINITIONS
- Draft recital paragraphs establishing the mutual intent to share confidential information for [PURPOSE]
- Define "Confidential Information" broadly to cover written, oral, visual, and electronic disclosures
- Include examples that specifically cover [INFO_TYPES] without limiting the general definition
- Define "Disclosing Party" and "Receiving Party" as reciprocal roles that apply to both parties
- Define "Representatives" to include employees, officers, directors, advisors, and authorized contractors
- Establish that information need not be marked "confidential" to be protected if a reasonable person would understand its confidential nature

### 2. OBLIGATIONS OF RECEIVING PARTY
- Require the receiving party to protect confidential information with at least the same degree of care used for its own (but no less than reasonable care)
- Limit use of confidential information strictly to the stated [PURPOSE]
- Restrict disclosure to Representatives who need to know and are bound by equivalent confidentiality obligations
- Prohibit copying or reproduction except as reasonably necessary for the permitted purpose
- Require prompt notification if the receiving party becomes aware of any unauthorized disclosure
- Establish that the receiving party is responsible for breaches by its Representatives

### 3. EXCLUSIONS FROM CONFIDENTIALITY
- Exclude information that is or becomes publicly available through no fault of the receiving party
- Exclude information already in the receiving party's possession before disclosure (with documentation)
- Exclude information independently developed without reference to confidential information
- Exclude information received from a third party without breach of any obligation
- Exclude information that must be disclosed by law, regulation, or court order — with a requirement to provide prompt notice and cooperate to seek protective treatment
- Clarify that the burden of proving an exclusion applies rests on the receiving party

### 4. TERM, RETURN, AND DESTRUCTION
- Set the agreement term at [NDA_DURATION] from [EFFECTIVE_DATE]
- Specify that confidentiality obligations survive expiration or termination for a defined period
- Require return or destruction of all confidential materials within 30 days of written request or termination
- Permit retention of one archival copy solely for compliance and legal audit purposes
- Require written certification of destruction upon request
- Address electronically stored information in backups and disaster recovery systems

### 5. REMEDIES AND ENFORCEMENT
- Acknowledge that breach may cause irreparable harm for which monetary damages are insufficient
- Establish the right to seek injunctive relief without the need to post a bond
- Preserve the right to pursue all other legal and equitable remedies
- Clarify that no waiver of any breach constitutes a waiver of any subsequent breach
- Specify whether the prevailing party in any dispute is entitled to recover attorneys' fees
- Address the interaction between this NDA and any subsequent definitive agreement

### 6. GENERAL PROVISIONS
- Specify governing law as [GOVERNING_JURISDICTION] without conflict-of-law principles
- Establish the venue for any disputes arising under the agreement
- State that the NDA does not create a partnership, joint venture, or agency relationship
- Clarify that no obligation to proceed with any transaction or business relationship is created
- Include assignment restrictions (no assignment without prior written consent)
- Add severability, entire agreement, amendment (written only), and counterparts clauses
- Include signature blocks with printed name, title, date, and address lines for both parties

Deliver the complete mutual NDA in a professional format with numbered sections, clear defined terms, and dual signature blocks. Include a one-page summary cover sheet listing the key terms (parties, purpose, duration, jurisdiction) for quick reference.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified attorney licensed in your jurisdiction before executing or relying on any legal document.

Be specific to my situation. No generic filler.
