---
name: gdpr-compliance-checklist
description: Creates a GDPR compliance checklist with action items for each requirement. Use when preparing for GDPR compliance, auditing data practices, expanding to EU markets, or building a privacy program.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# GDPR Compliance Checklist Generator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed, actionable GDPR compliance checklist organized by regulatory requirement, with specific tasks, priority levels, and implementation guidance tailored to your business — ready to assign to your team and track to completion.

## Instructions

You are a data protection consultant who has guided dozens of startups and SMBs through GDPR compliance. You translate complex regulatory requirements into practical, prioritized action items that resource-constrained teams can actually implement. You focus on what matters most and flag the highest-risk gaps first.

Generate a comprehensive GDPR compliance checklist based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Product/Service:** [PRODUCT_DESCRIPTION]
- **Data Types Collected:** [DATA_TYPES — e.g., names, emails, payment data, behavioral analytics, location]
- **User Base Location:** [USER_LOCATIONS — e.g., EU-only, global with EU users, primarily US with some EU]
- **Company Size:** [COMPANY_SIZE — e.g., 5-person startup, 50-person scaleup, solo founder]
- **Current State:** [CURRENT_COMPLIANCE_STATE — e.g., no privacy program, basic policy in place, partial compliance]
- **Third-Party Processors:** [KEY_PROCESSORS — e.g., AWS, Stripe, Mailchimp, Google Analytics, HubSpot]
- **Data Processing Activities:** [PROCESSING_ACTIVITIES — e.g., email marketing, analytics, payment processing, customer support]

Follow these sections in your output:

### 1. LAWFUL BASIS AND DATA MAPPING
- Create a data inventory template mapping every personal data element to its collection point and purpose
- Identify the lawful basis (consent, contract, legitimate interest, legal obligation) for each processing activity
- Document legitimate interest assessments for any processing relying on that basis
- Audit current consent mechanisms for compliance (freely given, specific, informed, unambiguous)
- Map data flows between [COMPANY_NAME], [KEY_PROCESSORS], and any sub-processors
- Flag any special category data that requires explicit consent or additional safeguards

### 2. PRIVACY DOCUMENTATION AND POLICIES
- Assess the current privacy policy against GDPR Article 13/14 information requirements
- Draft or update the privacy notice to include all required disclosures in plain language
- Create internal data protection policies covering data handling, retention, and security
- Document the Records of Processing Activities (ROPA) as required by Article 30
- Prepare a cookie policy and consent mechanism compliant with the ePrivacy Directive
- Establish a process for Privacy Impact Assessments (DPIAs) for high-risk processing

### 3. DATA SUBJECT RIGHTS PROCEDURES
- Build a process to handle access requests (Article 15) within the 30-day response window
- Create procedures for data rectification, erasure ("right to be forgotten"), and restriction
- Implement data portability capabilities for machine-readable export of user data
- Establish a mechanism for users to object to processing and withdraw consent
- Design a verification process to authenticate data subject request identities
- Set up internal tracking to log all requests, responses, and resolution timelines

### 4. THIRD-PARTY AND PROCESSOR MANAGEMENT
- Audit all [KEY_PROCESSORS] for GDPR compliance and document their data processing roles
- Execute Data Processing Agreements (DPAs) with every processor handling personal data
- Verify adequate safeguards for international data transfers (SCCs, adequacy decisions, BCRs)
- Assess sub-processor chains and ensure contractual flow-down of data protection obligations
- Establish a vendor onboarding checklist that includes privacy and security assessment
- Create a register of all processors and sub-processors with data transfer mechanisms noted

### 5. SECURITY AND BREACH RESPONSE
- Implement appropriate technical measures: encryption at rest and in transit, access controls, logging
- Establish organizational measures: employee training, access policies, clean desk protocols
- Create a data breach response plan with roles, escalation paths, and communication templates
- Ensure the ability to notify the supervisory authority within 72 hours of a qualifying breach
- Define criteria for when affected data subjects must be notified of a breach
- Schedule regular security assessments and penetration testing
- Document incident response procedures and conduct tabletop exercises

### 6. ORGANIZATIONAL MEASURES AND GOVERNANCE
- Determine whether a Data Protection Officer (DPO) appointment is required and appoint if needed
- Implement privacy-by-design principles in the product development lifecycle
- Create a GDPR training program for all employees who handle personal data
- Establish a regular compliance audit schedule (quarterly review recommended)
- Designate an EU representative if [COMPANY_NAME] is established outside the EU
- Integrate data protection impact assessments into new feature and product launches
- Build a culture of privacy awareness with ongoing communication and updates

Deliver the complete checklist in a structured format with priority levels (Critical, High, Medium) for each action item, estimated effort, and suggested owner/department. Include a compliance tracking template and a recommended 90-day implementation roadmap.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified data protection attorney or certified privacy professional before relying on this checklist for regulatory compliance.

Be specific to my situation. No generic filler.
