---
name: dmca-response
description: Creates DMCA takedown notice and counter-notice templates for copyright disputes. Use when filing a copyright takedown, responding to infringement claims, protecting original content, or handling user-generated content disputes.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# DMCA Response Template Generator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
Complete DMCA takedown notice and counter-notice templates with step-by-step filing instructions, internal handling procedures, and a designated agent setup guide — ready for customization and use after attorney review.

## Instructions

You are a copyright and internet law specialist who helps companies navigate DMCA takedown procedures from both sides — as content owners protecting their work and as platforms responding to claims. You understand the statutory requirements under 17 U.S.C. 512 and draft notices that meet every legal element to avoid rejection.

Generate a complete DMCA response package based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Company Role:** [COMPANY_ROLE — e.g., content owner filing takedown, platform receiving takedowns, both]
- **Type of Content:** [CONTENT_TYPE — e.g., software code, images, written content, videos, music, product listings]
- **Platform/Website:** [PLATFORM_URL]
- **Designated DMCA Agent:** [AGENT_NAME_AND_CONTACT]
- **Common Infringement Scenarios:** [INFRINGEMENT_SCENARIOS — e.g., scraped blog content, copied product photos, pirated software, unauthorized use of brand assets]

Follow these sections in your output:

### 1. DMCA TAKEDOWN NOTICE TEMPLATE
- Draft a compliant takedown notice meeting all requirements of 17 U.S.C. 512(c)(3)
- Include placeholder fields for: copyright owner identification, description of copyrighted work, URL of infringing material, and URL of original work
- Add the required good-faith statement that the use is not authorized by the copyright owner, its agent, or law
- Include the accuracy and perjury statement required by statute
- Provide a physical or electronic signature line for the copyright owner or authorized agent
- Add clear instructions for where and how to send the notice to major platforms
- Include a cover letter template for professional correspondence with the infringing party

### 2. COUNTER-NOTICE TEMPLATE
- Draft a compliant counter-notification meeting all requirements of 17 U.S.C. 512(g)(3)
- Include fields for: subscriber identification, identification of removed material and its location, consent to jurisdiction
- Add the required good-faith statement that material was removed through mistake or misidentification
- Include the perjury penalty acknowledgment
- Provide a signature line and contact information block
- Explain the 10-14 business day restoration timeline after counter-notice is filed
- Note the copyright owner's right to file a federal lawsuit within that window

### 3. PLATFORM DMCA POLICY AND PROCEDURES
- Draft a public-facing DMCA policy page for [PLATFORM_URL] with designated agent information
- Create an internal workflow for receiving, reviewing, and acting on takedown notices
- Define the review process to assess whether a notice meets all statutory requirements
- Establish procedures for notifying the user whose content is subject to takedown
- Outline the process for handling counter-notices and restoring content
- Define the repeat infringer policy required to maintain safe harbor protection
- Include a template response for acknowledging receipt of takedown notices

### 4. DESIGNATED AGENT REGISTRATION
- Provide step-by-step instructions for registering a DMCA designated agent with the U.S. Copyright Office
- Detail the information required for the online registration system
- Specify the registration fee and renewal requirements
- Explain the requirement to publish agent information on the company's website
- Draft the website notice with [AGENT_NAME_AND_CONTACT] details
- Address updating the registration when agent information changes
- Note the importance of registration for maintaining Section 512 safe harbor protection

### 5. COMMON SCENARIOS AND RESPONSE PLAYBOOKS
- Create a response playbook for each [INFRINGEMENT_SCENARIOS] with specific handling instructions
- Address how to evaluate fair use claims before sending or responding to a takedown
- Provide guidance on distinguishing between valid takedowns and abusive or fraudulent claims
- Include a decision tree for determining when to send a takedown vs. a cease-and-desist letter
- Address international copyright considerations for cross-border infringement
- Outline when to escalate to outside counsel versus handling internally
- Cover the specific DMCA procedures for major platforms (Google, social media, hosting providers)

### 6. RECORD-KEEPING AND COMPLIANCE
- Define the documentation requirements for every takedown notice sent and received
- Create a tracking log template with fields for date, claimant, content, status, and resolution
- Establish retention periods for DMCA correspondence and action records
- Document the repeat infringer tracking system and termination thresholds
- Set up a regular review cadence to audit open claims and compliance status
- Include metrics to track: notices received, notices sent, counter-notices, restorations, and escalations

Deliver the complete DMCA package with ready-to-use notice templates, internal procedure documents, a public-facing policy page draft, and filing instructions. Format all templates with clear field labels and instructions for completion.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. DMCA notices and counter-notices carry perjury penalties under federal law. Consult a qualified intellectual property attorney before filing any DMCA notice, counter-notice, or relying on these templates for legal action.

Be specific to my situation. No generic filler.
