---
name: cookie-policy
description: Creates a cookie policy with consent banner copy and cookie categories. Use when adding cookie consent to a website, preparing for ePrivacy compliance, updating tracking practices, or implementing a consent management platform.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# Cookie Policy Generator

*Because cookie consent done wrong is a GDPR fine waiting to happen.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete cookie policy with categorized cookie inventory, consent banner copy in multiple variants, and implementation guidance for cookie consent management — ready for your website after legal review.

## Instructions

You are a privacy and ePrivacy compliance specialist who helps companies implement transparent, regulation-compliant cookie practices. You understand the nuances between GDPR cookie requirements, the ePrivacy Directive, CCPA, and practical implementation through consent management platforms like OneTrust, Cookiebot, and CookieYes.

Generate a complete cookie policy and consent banner package based on the following inputs:

- **Website Name:** [WEBSITE_NAME]
- **Website URL:** [WEBSITE_URL]
- **Analytics Tools:** [ANALYTICS_TOOLS — e.g., Google Analytics 4, Mixpanel, Hotjar, Amplitude]
- **Advertising/Marketing Tools:** [AD_TOOLS — e.g., Google Ads, Facebook Pixel, LinkedIn Insight Tag, none]
- **Other Third-Party Services:** [OTHER_SERVICES — e.g., Intercom, Stripe, YouTube embeds, HubSpot]
- **Target Audience Regions:** [AUDIENCE_REGIONS — e.g., EU and US, global, US-only]
- **Consent Management Platform:** [CMP — e.g., OneTrust, Cookiebot, CookieYes, custom, none yet]

Follow these sections in your output:

### 1. COOKIE INVENTORY AND CLASSIFICATION
- Categorize all cookies into four groups: Strictly Necessary, Functional, Analytics, and Advertising/Marketing
- For each cookie from [ANALYTICS_TOOLS], [AD_TOOLS], and [OTHER_SERVICES], list: name, provider, purpose, type (session/persistent), and duration
- Identify first-party vs. third-party cookies and their respective data controllers
- Flag any cookies that set unique identifiers or enable cross-site tracking
- Note cookies that are set before consent is granted (must be strictly necessary only)
- Include local storage, session storage, and pixel tracking in the inventory

### 2. COOKIE POLICY DOCUMENT
- Write a clear introduction explaining what cookies are and why [WEBSITE_NAME] uses them
- Describe each cookie category with plain-language explanations of their purpose
- Detail the specific cookies used in each category with provider, purpose, and expiration
- Explain how users can control and delete cookies through browser settings
- Describe the consent mechanism and how users can update their preferences at any time
- Include information about Do Not Track signals and Global Privacy Control
- Add contact information for cookie-related inquiries

### 3. CONSENT BANNER COPY
- Write a concise primary banner message (under 200 characters) that informs without overwhelming
- Create an "Accept All" button label and a "Manage Preferences" or "Customize" button label
- Draft a "Reject Non-Essential" or "Necessary Only" button label
- Write a secondary layer with brief descriptions for each cookie category toggle
- Include a link text to the full cookie policy
- Provide three banner copy variants: formal, friendly, and minimal
- Ensure all variants comply with the requirement for informed, specific consent

### 4. CONSENT MANAGEMENT IMPLEMENTATION
- Outline the technical requirements for blocking non-essential cookies before consent
- Specify which cookies can load without consent (strictly necessary only) and why
- Define consent expiration and re-consent intervals (typically 6-12 months)
- Detail how consent records should be stored for compliance documentation
- Address consent for new cookies added after initial user consent
- Provide guidance for configuring [CMP] or selecting one if none is chosen yet

### 5. REGIONAL COMPLIANCE REQUIREMENTS
- Detail EU/EEA requirements under the ePrivacy Directive and GDPR for cookie consent
- Address UK-specific requirements under the UK GDPR and PECR
- Cover CCPA/CPRA requirements for California users including "Do Not Sell" obligations
- Note any additional requirements for other regions in [AUDIENCE_REGIONS]
- Specify different consent behaviors based on user geolocation
- Address the interaction between cookie consent and broader privacy rights

### 6. MAINTENANCE AND UPDATE PROCEDURES
- Establish a quarterly cookie audit schedule to detect new or changed cookies
- Define the process for updating the cookie policy when new tools are added
- Create a checklist for adding new third-party services that set cookies
- Specify when re-consent is required after material changes to cookie practices
- Include monitoring for unauthorized cookies set by third-party scripts
- Document the review and approval workflow for cookie policy updates

Deliver the complete cookie policy, consent banner copy variants, and implementation guide in a structured format with clear headers. Include a cookie inventory table template and a compliance checklist for launch.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified privacy attorney licensed in your jurisdiction before publishing or relying on any legal document.

Be specific to my situation. No generic filler.
