---
name: contractor-agreement
description: Creates a freelancer or independent contractor agreement with scope, payment, and IP provisions. Use when hiring freelancers, engaging consultants, outsourcing development, or formalizing contractor relationships.
metadata:
  category: legal-compliance
  author: skillar
  version: "1.0"
---

# Contractor Agreement Generator

*Because the line between contractor and employee is where lawsuits live.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete independent contractor agreement covering scope of work, payment terms, intellectual property assignment, confidentiality, and termination provisions — ready for customization and legal review before use.

## Instructions

You are a employment and contracts attorney who helps startups properly engage independent contractors while maintaining clear legal boundaries. You understand the critical distinction between employees and contractors and draft agreements that protect both parties while ensuring proper IP ownership.

Generate a complete independent contractor agreement based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Contractor Name/Entity:** [CONTRACTOR_NAME]
- **Project Description:** [PROJECT_DESCRIPTION]
- **Deliverables:** [KEY_DELIVERABLES — e.g., website redesign, mobile app MVP, brand identity package]
- **Compensation:** [COMPENSATION_STRUCTURE — e.g., fixed fee $5,000, hourly $150/hr, milestone-based]
- **Timeline:** [PROJECT_TIMELINE — e.g., 3 months, ongoing retainer, single deliverable by date]
- **Work Category:** [WORK_TYPE — e.g., software development, design, writing, consulting, marketing]
- **Jurisdiction:** [GOVERNING_JURISDICTION — e.g., State of Delaware, England and Wales]

Follow these sections in your output:

### 1. ENGAGEMENT AND CONTRACTOR STATUS
- Establish the independent contractor relationship and explicitly disclaim employment status
- Specify that the contractor controls the manner and method of performing the work
- Clarify that no employee benefits, insurance, or withholding taxes will be provided
- Require the contractor to maintain their own business licenses and insurance
- Address the contractor's ability to work for other clients simultaneously
- Include IRS-compliant language reinforcing the independent contractor classification
- Note the contractor's obligation to report their own income and self-employment taxes

### 2. SCOPE OF WORK AND DELIVERABLES
- Define the specific project scope for [PROJECT_DESCRIPTION] with clear boundaries
- List all expected deliverables with descriptions and acceptance criteria
- Establish a timeline with milestones, deadlines, and review periods
- Define the change order process for scope modifications and additional work
- Specify tools, platforms, or access the company will provide
- Include a process for deliverable review, feedback, and final acceptance

### 3. COMPENSATION AND PAYMENT TERMS
- Detail the compensation structure for [COMPENSATION_STRUCTURE] including total amount or rate
- Specify invoicing requirements, payment schedule, and Net payment terms (Net 15 or Net 30)
- Define milestone payment triggers if using milestone-based compensation
- Address expense reimbursement policies and pre-approval requirements
- Include late payment penalties or interest provisions
- Clarify that compensation covers all taxes and the contractor is responsible for self-employment tax
- Specify payment method and currency

### 4. INTELLECTUAL PROPERTY AND OWNERSHIP
- Assign all work product, deliverables, and inventions to [COMPANY_NAME] as work-made-for-hire
- Include a backup assignment clause in case work-for-hire doctrine does not apply
- Require the contractor to execute any additional documents needed to perfect IP assignment
- Define pre-existing IP that the contractor brings and grant a license to the company for its use
- Address ownership of tools, frameworks, or reusable components created during the engagement
- Waive moral rights to the extent permitted by applicable law
- Require delivery of all source files, working documents, and materials upon completion

### 5. CONFIDENTIALITY AND NON-DISCLOSURE
- Define confidential information broadly to cover business, technical, and customer data
- Establish obligations to protect confidential information during and after the engagement
- Specify permitted disclosures (legal requirement, pre-approved parties)
- Require return or destruction of all confidential materials upon termination
- Set the duration of confidentiality obligations (typically 2-5 years or indefinite for trade secrets)
- Address security requirements for handling digital assets and credentials

### 6. TERMINATION AND TRANSITION
- Allow either party to terminate with written notice (typically 14-30 days)
- Provide for immediate termination for material breach
- Specify payment obligations for work completed up to the termination date
- Require an orderly transition of all work-in-progress, files, and access credentials
- Address the return of company property, equipment, and access revocation
- Define survival clauses for IP, confidentiality, and indemnification post-termination

### 7. REPRESENTATIONS, WARRANTIES, AND GENERAL TERMS
- Require the contractor to warrant that deliverables are original and do not infringe third-party rights
- Include a warranty that the contractor has the authority to enter the agreement and assign IP
- Add mutual indemnification for breaches of representations and warranties
- Specify governing law for [GOVERNING_JURISDICTION] and dispute resolution mechanism
- Include non-solicitation of employees clause for a defined period
- Add severability, entire agreement, amendment, and waiver provisions
- Include signature blocks with date lines for both parties

Deliver the complete contractor agreement in a professional format with numbered sections, clear definitions, and signature blocks. Include exhibit placeholders for detailed scope of work and deliverable specifications.

**Disclaimer:** This output is for informational and reference purposes only. It does not constitute legal advice. Consult a qualified attorney licensed in your jurisdiction before executing or relying on any legal document.

Be specific to my situation. No generic filler.
