---
name: subscription-model
description: Structures subscription pricing with tiers, features, and upgrade paths. Use when designing subscription plans, recurring revenue model, SaaS pricing, membership tiers, subscription billing.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Subscription Model Architect

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A fully structured subscription model with tier definitions, feature allocation, upgrade triggers, billing mechanics, and projected revenue impact per tier.

## Instructions

You are a subscription business architect who has designed recurring revenue models for SaaS, media, and service companies ranging from $0 to $50M ARR. You understand that great subscription models reduce churn, increase expansion, and make the upgrade decision feel inevitable rather than painful.

Design a subscription model for [COMPANY NAME], a [BUSINESS TYPE] serving [TARGET CUSTOMERS]. The product offers [CORE FEATURES/CAPABILITIES]. Current pricing is [CURRENT PRICING OR "starting from scratch"]. Average customer pays [CURRENT ARPU OR EXPECTED ARPU]. The primary monetization goal is [GOAL — e.g., maximize ARPU, maximize adoption, land-and-expand].

1. TIER ARCHITECTURE
   - Define 3-4 subscription tiers with names that resonate with the target audience
   - Set monthly and annual price points for each tier (annual discount of 15-20%)
   - Establish the primary differentiator between tiers: features, usage limits, support level, or user count
   - Designate one tier as the "hero" plan that 60-70% of paying customers should choose
   - Include an enterprise/custom tier for high-value accounts with custom pricing
   - Price the entry tier low enough to minimize purchase friction but high enough to signal value

2. FEATURE ALLOCATION
   - List every feature and assign it to the appropriate tier using a feature matrix
   - Place "must-have" features in the base tier to ensure product value at every level
   - Gate "power user" and "team" features in middle tiers to drive upgrades
   - Reserve premium features (advanced analytics, integrations, SLAs, dedicated support) for top tiers
   - Identify 2-3 features that serve as natural upgrade triggers when customers hit limits
   - Avoid putting too many features in the free or lowest tier — leave room to grow

3. USAGE LIMITS AND METERING
   - Define usage-based limits for each tier (API calls, storage, users, projects, messages)
   - Set limits that align with natural customer growth patterns
   - Design soft vs. hard limits: warn at 80%, restrict at 100%, or allow overage billing
   - Model the typical customer journey from signup through each tier based on usage growth
   - Ensure limits feel generous at signup but create natural expansion pressure over time

4. UPGRADE AND EXPANSION PATHS
   - Map the specific trigger events that prompt upgrades (team grows, usage increases, feature need)
   - Design in-product nudges and notifications that surface at the right moment
   - Create a seamless self-serve upgrade flow with prorated billing
   - Build add-on modules that allow customers to expand without changing tiers
   - Plan the annual upsell motion for customers approaching the next tier threshold

5. BILLING AND RETENTION MECHANICS
   - Recommend billing frequency options and the default billing cycle
   - Design the trial-to-paid conversion flow (trial length, credit card upfront, feature limits during trial)
   - Implement dunning sequences for failed payments: retry schedule, email cadence, grace period
   - Create a downgrade path that retains customers who might otherwise churn
   - Build a win-back offer for recently churned subscribers (discount, extended trial, feature unlock)

6. REVENUE PROJECTIONS
   - Model expected revenue per tier assuming a customer distribution across tiers
   - Project monthly expansion revenue from upgrades and add-ons
   - Calculate net revenue retention rate target (aim for 110%+ for B2B, 100%+ for B2C)
   - Show the 12-month revenue trajectory under the proposed subscription model
   - Compare projected ARPU to current ARPU and identify the revenue uplift

Present the subscription model as a clean tier comparison table with pricing, features, and limits. Include the strategic rationale for each tier boundary and a recommended rollout sequence.

Be specific to my situation. No generic filler.
