---
name: revenue-forecast
description: Creates a 12-month revenue forecast with pessimistic, realistic, and optimistic scenarios. Use when forecasting revenue, projecting sales, planning revenue targets, modeling growth scenarios.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Revenue Forecast Generator

*Because good forecasts are built bottom-up from real drivers, not top-down from wishes.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed 12-month revenue forecast across three scenarios with monthly breakdowns, growth assumptions, and leading indicators to track forecast accuracy.

## Instructions

You are a revenue operations expert who has built forecasting models for startups scaling from $0 to $10M ARR. You understand that good forecasts are built bottom-up from real drivers, not top-down from wishful thinking.

Create a 12-month revenue forecast for [COMPANY NAME], a [BUSINESS TYPE] with [CURRENT MRR/REVENUE]. The primary revenue model is [REVENUE MODEL — e.g., subscriptions, transactions, contracts]. Current customer count is [NUMBER OF CUSTOMERS] with an average deal size of [AVERAGE DEAL SIZE]. The sales cycle is approximately [SALES CYCLE LENGTH].

1. REVENUE DRIVERS ANALYSIS
   - Identify the 5-7 key inputs that drive revenue (leads, conversion rate, deal size, expansion, churn)
   - Document the current value of each driver with supporting data
   - Assess which drivers are most controllable and which are market-dependent
   - Map how each driver compounds or interacts with others
   - Establish the historical trend for each driver over the past [TIME PERIOD]

2. BOTTOM-UP MODEL
   - Build the forecast from individual revenue streams and customer segments
   - Model new customer acquisition month by month based on pipeline and capacity
   - Include expansion revenue from upsells, cross-sells, and seat growth
   - Subtract churned revenue and downgrades with realistic loss assumptions
   - Account for payment timing, annual vs. monthly billing mix, and collections lag

3. THREE SCENARIOS
   - PESSIMISTIC: Growth stalls, churn increases, market headwinds emerge — what is the floor?
   - REALISTIC: Current trajectory continues with modest improvements in key drivers
   - OPTIMISTIC: Key initiatives succeed, market tailwinds, team execution fires on all cylinders
   - For each scenario, state exactly which assumptions change and by how much
   - Calculate the probability-weighted expected revenue across scenarios

4. MONTHLY BREAKDOWN TABLE
   - Present a month-by-month table showing MRR, new MRR, expansion MRR, churned MRR, net new MRR
   - Include cumulative customer count and average revenue per customer
   - Show month-over-month growth rate and trailing 3-month average growth
   - Highlight months where seasonal factors or planned initiatives affect the forecast
   - Mark key milestones: first $X MRR, break-even MRR, target MRR

5. LEADING INDICATORS
   - Define 4-6 leading indicators that predict whether the forecast is on track
   - Set specific monthly targets for each indicator (pipeline value, demo bookings, trial starts)
   - Create an early warning system: which metrics signal the forecast is drifting off course
   - Recommend a weekly review cadence with the exact numbers to check
   - Specify when to trigger a forecast revision based on indicator performance

6. RISKS AND DEPENDENCIES
   - List the top 5 risks that could cause the forecast to miss
   - Identify external dependencies: market conditions, partnerships, platform changes
   - Map each risk to a specific mitigation action
   - Quantify the revenue impact if each risk materializes

Present the forecast in clean monthly tables. Include a summary dashboard at the top showing the 12-month total for each scenario with key growth metrics.

Be specific to my situation. No generic filler.
