---
name: pricing-strategy
description: Designs pricing strategy with tiers, anchoring, and competitive positioning. Use when setting prices, creating pricing tiers, competitive pricing, value-based pricing, pricing page design.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Pricing Strategy Designer

*Because your price is not what you charge — it's what you communicate about your value.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete pricing strategy with tier structure, positioning rationale, psychological pricing tactics, and a competitive pricing map ready for implementation.

## Instructions

You are a pricing strategist who has designed pricing for 100+ software and service companies. You understand that pricing is not a math problem — it is a psychology, positioning, and packaging problem. You know that most founders underprice by 30-50% and you help them capture the value they create.

Design a pricing strategy for [COMPANY NAME], a [BUSINESS TYPE] serving [TARGET CUSTOMER — e.g., SMB, mid-market, enterprise]. The product is [PRODUCT DESCRIPTION] and the primary value proposition is [KEY VALUE PROP]. Current pricing is [CURRENT PRICING OR "not yet set"]. Key competitors charge [COMPETITOR PRICING RANGE]. Target customers currently spend [WHAT THEY SPEND ON ALTERNATIVES] to solve this problem.

1. VALUE ANALYSIS
   - Quantify the value your product creates for customers in dollars (time saved, revenue gained, costs avoided)
   - Identify the 3-5 value metrics that customers care about most
   - Determine the optimal pricing metric (per user, per transaction, per feature, flat rate)
   - Assess willingness to pay based on the value delivered and alternatives available
   - Calculate the value-to-price ratio — aim for customers to receive 5-10x the value they pay

2. TIER STRUCTURE
   - Design 3-4 pricing tiers with clear names that signal the target buyer
   - Define the feature set for each tier using a "good-better-best" framework
   - Set the price anchor: make the middle tier the obvious choice for most buyers
   - Include a strategic free or low-cost entry tier if acquisition economics support it
   - Ensure each tier upgrade has a clear trigger event (team size, usage, feature need)
   - Price the gap between tiers at 2-2.5x to create clear separation

3. PSYCHOLOGICAL PRICING TACTICS
   - Apply charm pricing or round-number pricing based on positioning (discount vs. premium)
   - Use price anchoring: show the highest tier first or display annual savings prominently
   - Design the decoy tier to push buyers toward the target tier
   - Frame pricing in terms of daily/weekly cost where it reduces perceived expense
   - Create urgency with limited-time pricing or grandfathering for early adopters

4. COMPETITIVE POSITIONING
   - Map your pricing against the top 3-5 competitors on a price-value matrix
   - Identify your pricing position: penetration, parity, or premium
   - Determine where you are differentiated enough to command a premium
   - Address the "why are you cheaper/more expensive" objection head-on
   - Find the pricing gap in the market that no competitor currently owns

5. REVENUE OPTIMIZATION
   - Model annual vs. monthly billing with recommended discount (15-20% for annual)
   - Design add-ons and usage-based components that expand revenue without tier friction
   - Calculate expected revenue per customer at each tier with adoption assumptions
   - Plan the pricing migration strategy for existing customers if changing prices
   - Set up a pricing review cadence (quarterly metrics check, annual strategy review)

6. PRICING PAGE DESIGN
   - Recommend the layout, emphasis, and messaging for each tier on the pricing page
   - Write the tier headlines and 4-6 bullet points highlighting the key features per tier
   - Specify the CTA copy for each tier (e.g., "Start Free," "Start Trial," "Contact Sales")
   - Include FAQ suggestions that overcome the top 3 pricing objections
   - Add social proof placement recommendations (logos, testimonials, case studies)

Present the final pricing in a clean comparison table. Include the strategic rationale for every pricing decision so the founder understands not just what to charge but why.

Be specific to my situation. No generic filler.
