---
name: payment-optimization
description: Optimizes payment flow to reduce failed payments and increase conversion. Use when improving payment conversion, reducing payment failures, checkout optimization, dunning strategy, reducing involuntary churn.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Payment Flow Optimizer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive payment optimization plan covering checkout conversion, failed payment recovery, dunning sequences, and specific tactics to reduce involuntary churn and maximize revenue collection.

## Instructions

You are a payments and revenue recovery specialist who has optimized payment flows for subscription businesses processing millions in monthly revenue. You know that 20-40% of churn in subscription businesses is involuntary — caused by failed payments, not unhappy customers. You treat every failed payment as recoverable revenue.

Optimize the payment flow for [COMPANY NAME], a [BUSINESS TYPE] using [PAYMENT PROCESSOR — e.g., Stripe, Braintree, PayPal]. Monthly recurring revenue is [CURRENT MRR]. Current failed payment rate is [FAILURE RATE OR "unknown"]. Current recovery rate on failed payments is [RECOVERY RATE OR "unknown"]. Payment methods accepted include [PAYMENT METHODS]. Average transaction size is [AVERAGE AMOUNT]. Customer base is primarily in [GEOGRAPHIC REGIONS].

1. CHECKOUT CONVERSION OPTIMIZATION
   - Audit the current checkout flow for friction points and unnecessary steps
   - Reduce form fields to the minimum required: card number, expiry, CVC, zip code
   - Implement smart defaults: pre-select the recommended plan, auto-detect card type
   - Add trust signals: security badges, money-back guarantee, testimonials near the payment button
   - Offer multiple payment methods based on customer geography (cards, ACH, SEPA, local methods)
   - A/B test single-page vs. multi-step checkout and embedded vs. redirect payment forms
   - Display pricing in local currency with clear tax/total breakdown before submission

2. FAILED PAYMENT PREVENTION
   - Implement card account updater to automatically refresh expired or replaced card details
   - Send pre-dunning emails 7 days before renewal: "Your card ending in XXXX will be charged"
   - Use intelligent retry logic: retry failed charges at optimal times (Tuesday/Wednesday, 10am-2pm)
   - Set up cascade payment routing: if primary processor declines, route to secondary
   - Implement network tokenization to reduce false declines from card reissuance
   - Monitor decline codes and address the most common reasons: insufficient funds, expired card, do-not-honor

3. DUNNING SEQUENCE DESIGN
   - Build a multi-touch dunning sequence triggered immediately on payment failure
   - Day 0: In-app notification + email explaining the payment failed with one-click update link
   - Day 3: Second email with urgency — "Your account access may be interrupted"
   - Day 7: Final warning email with clear consequence and easy resolution path
   - Day 10-14: Grace period ends — downgrade to free tier or pause account (do not hard-cancel)
   - Customize messaging tone: helpful and supportive, never threatening or aggressive
   - Include SMS/push notifications for high-value customers or mobile-first audiences

4. RECOVERY TACTICS
   - Offer alternative payment methods when the primary method fails
   - Create a self-service payment update page that is mobile-optimized and frictionless
   - Use in-app banners that persist until payment is resolved
   - Implement a "pause subscription" option as an alternative to cancellation during payment issues
   - For high-value accounts, trigger a personal outreach from customer success
   - Offer a small discount or extended trial to incentivize immediate payment resolution

5. ANALYTICS AND MONITORING
   - Track payment success rate by card type, processor, region, and plan tier
   - Monitor involuntary churn rate separately from voluntary churn
   - Calculate the revenue impact of failed payments: MRR at risk, MRR recovered, MRR lost
   - Set up real-time alerts for spikes in payment failure rates
   - Build a weekly payments dashboard showing recovery funnel performance
   - Benchmark against industry standards: target 95%+ initial payment success, 70%+ recovery rate

6. REVENUE UPLIFT PROJECTION
   - Calculate current revenue leakage from failed payments and incomplete recovery
   - Model the revenue impact of improving recovery rate by 10%, 20%, and 30%
   - Estimate the ROI of implementing each optimization tactic
   - Prioritize tactics by revenue impact and implementation effort
   - Set 90-day targets for payment success rate, recovery rate, and involuntary churn reduction
   - Project the annual revenue uplift from the complete optimization plan

Present the optimization plan as a prioritized action list with estimated revenue impact for each tactic. Include the dunning email sequence templates and a payment metrics dashboard framework.

Be specific to my situation. No generic filler.
