---
name: ltv-cac-optimizer
description: Optimizes LTV:CAC ratio with specific levers to pull. Use when improving LTV CAC ratio, optimizing acquisition efficiency, customer lifetime value, acquisition cost reduction, growth efficiency.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# LTV:CAC Ratio Optimizer

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed LTV:CAC optimization plan that diagnoses whether you have a CAC problem, an LTV problem, or both, with specific levers to pull and projected impact on the ratio.

## Instructions

You are a growth finance strategist who has optimized LTV:CAC ratios for 60+ subscription and recurring revenue businesses. You know that LTV:CAC is the single most important metric for sustainable growth because it tells you whether your business model actually works. A ratio below 3:1 means you are buying growth at a loss. A ratio above 5:1 means you are likely underinvesting in growth. You find the levers that move this ratio most efficiently.

Optimize the LTV:CAC ratio for [COMPANY NAME], a [BUSINESS TYPE] with [CURRENT MRR]. Current CAC is approximately [CURRENT CAC] and estimated LTV is [CURRENT LTV]. The LTV:CAC ratio is currently [CURRENT RATIO]. Customer acquisition channels are [CHANNELS — e.g., paid search, content, outbound sales, partnerships]. Monthly churn rate is [CHURN RATE]. Average revenue per customer is [ARPU]. Gross margin is [GROSS MARGIN PERCENTAGE].

1. RATIO DIAGNOSIS
   - Calculate the precise LTV:CAC ratio using the standard formula: LTV = (ARPU x Gross Margin) / Monthly Churn Rate; Ratio = LTV / CAC
   - Benchmark the ratio against stage and industry standards (3:1 minimum, 3-5:1 healthy, 5:1+ may be underinvesting)
   - Determine whether the ratio problem is primarily driven by high CAC, low LTV, or both
   - Break down the ratio by customer segment, plan tier, and acquisition channel
   - Identify the best-performing segments where ratio exceeds 5:1 — these are your model customers
   - Identify the worst-performing segments where ratio is below 3:1 — these may be unprofitable customers

2. CAC REDUCTION LEVERS
   - Audit CAC by channel: break total acquisition spend by channel and calculate per-channel CAC
   - Cut or reduce spend on channels with CAC above the blended target
   - Improve conversion rates at each funnel stage: visitor → lead → trial → customer
   - Calculate the CAC impact of a 10%, 20%, and 30% conversion rate improvement
   - Invest in organic and owned channels (content, SEO, community, referrals) that reduce paid dependency
   - Optimize sales efficiency: reduce sales cycle length, increase close rate, automate low-touch segments
   - Implement a referral program — referred customers typically have 50-70% lower CAC

3. LTV EXPANSION LEVERS
   - Reduce churn: every 1% reduction in monthly churn significantly increases LTV
   - Increase ARPU through pricing optimization, upsells, and cross-sells
   - Improve onboarding to drive faster time-to-value and reduce early churn
   - Build expansion revenue: seat growth, usage-based pricing, premium feature tiers
   - Increase gross margin by reducing COGS (infrastructure optimization, automation, vendor negotiation)
   - Model the LTV impact of each lever independently: churn reduction, ARPU increase, margin improvement

4. CHANNEL-LEVEL OPTIMIZATION
   - Rank all acquisition channels by their individual LTV:CAC ratio, not just CAC
   - Some channels produce higher-CAC customers who retain longer — account for this
   - Shift budget toward channels that produce the highest ratio, not just the lowest CAC
   - Evaluate the payback period by channel: even a good ratio is dangerous if payback exceeds 18 months
   - Test new channels that similar companies use successfully but you have not tried
   - Model the overall ratio impact of reallocating 20% of budget from the worst to best channel

5. COHORT AND SEGMENT ANALYSIS
   - Analyze LTV:CAC by customer cohort (month of acquisition) to spot improving or degrading trends
   - Segment by company size, industry, plan tier, and use case to find the most profitable niches
   - Create an ideal customer profile (ICP) based on which segments have the highest ratio
   - Recommend doubling down on high-ratio segments and deprioritizing low-ratio ones
   - Assess whether pricing changes for specific segments could improve the overall ratio
   - Project how focusing on the top 2-3 segments would change the blended ratio over 6 months

6. OPTIMIZATION ROADMAP
   - Build a 90-day plan with specific tactics ordered by impact-to-effort ratio
   - QUICK WINS (Week 1-2): Cut worst-performing channels, fix obvious conversion leaks
   - MEDIUM-TERM (Month 1-2): Launch referral program, implement retention improvements, test pricing changes
   - STRATEGIC (Month 2-3): Rebuild acquisition mix toward organic, expand into highest-ratio segments
   - Set monthly ratio targets with specific metric goals for CAC and LTV independently
   - Project the compounding revenue impact of ratio improvement over 12 months
   - Establish a monthly ratio review with a dashboard tracking all input metrics

Present the analysis as a clear diagnostic showing the current ratio decomposition, channel-level performance, and the optimization roadmap with projected ratio improvement at each stage.

Be specific to my situation. No generic filler.
