---
name: invoice-template
description: Creates professional invoice template with payment terms and branding. Use when creating invoices, billing clients, invoice design, payment terms, freelance billing, client invoicing.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Invoice Template Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional, brandable invoice template with proper payment terms, line items, tax handling, and late payment policies ready to send to clients or integrate into your billing workflow.

## Instructions

You are a business finance consultant who has set up invoicing systems for hundreds of freelancers, agencies, and startups. You know that professional invoices get paid faster, reduce disputes, and reinforce brand credibility. You design invoices that are clear, legally sound, and optimized for prompt payment.

Create a professional invoice template for [COMPANY/FREELANCER NAME], a [BUSINESS TYPE] based in [LOCATION/COUNTRY]. The typical invoice is for [TYPE OF WORK/PRODUCTS — e.g., consulting, software development, design services, product sales]. Average invoice amount is [TYPICAL AMOUNT RANGE]. Clients are typically [CLIENT TYPE — e.g., small businesses, enterprises, individuals]. Preferred payment methods include [PAYMENT METHODS — e.g., bank transfer, PayPal, Stripe, check].

1. HEADER AND BRANDING
   - Include company name, logo placement area, and tagline
   - Add full business address, phone number, email, and website
   - Include tax ID, business registration number, or VAT number as required by [LOCATION]
   - Add the invoice number format (e.g., INV-2024-001) with sequential numbering guidance
   - Display the invoice date and due date prominently at the top
   - Use clean, professional formatting that reinforces brand identity

2. CLIENT AND PROJECT DETAILS
   - Include client company name, contact person, and billing address
   - Add a project reference or purchase order number field
   - Include a brief project description or scope reference
   - Add the billing period or service dates covered by this invoice
   - Include a "Bill To" and optional "Ship To" section for product businesses

3. LINE ITEMS AND PRICING
   - Create a clear table with columns: Description, Quantity/Hours, Rate, Amount
   - Include space for 5-10 line items with detailed descriptions
   - Add subtotal, applicable taxes (VAT, sales tax, GST based on [LOCATION]), and grand total
   - Include discount line if applicable (percentage or fixed amount)
   - Show currency clearly and consistently throughout
   - Add a notes field for additional charges, adjustments, or credits

4. PAYMENT TERMS AND CONDITIONS
   - State payment terms clearly: Net 15, Net 30, or due upon receipt
   - Specify accepted payment methods with relevant details (bank account, PayPal email, payment link)
   - Include late payment policy: percentage fee after due date (typically 1.5% per month)
   - Add early payment discount if offered (e.g., 2% discount if paid within 10 days)
   - Include wire transfer details: bank name, account number, routing/SWIFT code
   - State the currency and note any exchange rate policies for international clients

5. LEGAL AND COMPLIANCE
   - Include applicable tax disclaimers based on [LOCATION] regulations
   - Add reverse charge mechanism note if applicable for cross-border B2B invoices
   - Include terms of service reference or contract number
   - State dispute resolution process: contact within X days if discrepancies found
   - Add copyright or intellectual property transfer clause if relevant to the work

6. AUTOMATION AND WORKFLOW
   - Recommend an invoice numbering system that scales (prefix-year-sequence)
   - Suggest a follow-up schedule: send invoice, reminder at due date, follow-up at 7/14/30 days overdue
   - Provide email templates for sending the invoice and for payment reminders
   - Recommend tools for automating recurring invoices if applicable
   - Include a payment confirmation message template to send upon receipt

Present the invoice template in a clean, structured format that can be directly adapted into a spreadsheet, PDF template, or invoicing tool. Include all placeholder fields clearly marked for customization.

Be specific to my situation. No generic filler.
