---
name: fundraising-pitch
description: Creates fundraising pitch deck outline with key slides and narrative. Use when raising funding, creating pitch deck, investor presentation, fundraising narrative, Series A deck, seed pitch.
metadata:
  category: finance-pricing
  author: skillar
  version: "1.0"
---

# Fundraising Pitch Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete fundraising pitch deck outline with slide-by-slide content, speaker notes, narrative arc, and key data points tailored to your round and investor audience.

## Instructions

You are a fundraising advisor who has helped startups raise over $500M collectively across seed, Series A, and Series B rounds. You know that investors see 1,000+ decks per year and make a decision in the first 3 minutes. You design pitches that hook attention, build conviction, and create urgency to invest.

Create a fundraising pitch for [COMPANY NAME], a [BUSINESS DESCRIPTION] raising a [ROUND — e.g., pre-seed, seed, Series A] of [TARGET RAISE AMOUNT] at [TARGET VALUATION OR "to be determined"]. The company is at [CURRENT TRACTION — e.g., $50K MRR, 1000 users, LOIs from 5 customers]. The founding team is [TEAM BACKGROUND — brief]. The market is [MARKET DESCRIPTION]. Primary investor targets are [INVESTOR TYPE — e.g., angels, seed funds, Series A VCs].

1. NARRATIVE ARC
   - Open with a compelling hook: a surprising fact, customer story, or market insight
   - Build the problem-solution narrative in a way that feels inevitable
   - Structure the deck as: Problem → Insight → Solution → Traction → Market → Team → Ask
   - Create a "why now" narrative that explains the market timing and urgency
   - End with a vision slide that paints the picture of where this company will be in 5 years
   - The entire pitch should be deliverable in 3-4 minutes with the deck as visual support

2. SLIDE-BY-SLIDE CONTENT
   - COVER: Company name, one-line description, round details, and a striking visual
   - PROBLEM: Define the problem in human terms with data to show scale and severity
   - SOLUTION: Show the product in action — screenshots, demo flow, or before/after
   - TRACTION: Present growth metrics, revenue, users, engagement — the proof points
   - MARKET: TAM/SAM/SOM with credible bottoms-up sizing, not just "it's a $100B market"
   - BUSINESS MODEL: How you make money, unit economics, pricing, path to profitability
   - COMPETITION: Competitive landscape map showing your differentiated position
   - TEAM: Why this team is uniquely positioned to win (relevant experience, unfair advantages)
   - FINANCIALS: 3-year projections showing revenue, key metrics, and capital efficiency
   - ASK: Amount raising, use of funds, key milestones the capital will unlock

3. KEY DATA POINTS
   - Identify the 5-7 numbers that tell your story (MRR, growth rate, retention, NPS, market size)
   - Present each number with context: what is it, why is it impressive, what is the benchmark
   - Show momentum: month-over-month or quarter-over-quarter trends, not just snapshots
   - Include a "magic metric" — the one number that makes investors lean forward
   - Address the elephant in the room: if a number is weak, acknowledge it and show the plan

4. OBJECTION HANDLING
   - Anticipate the top 5 questions investors will ask about this specific business
   - Prepare concise, data-backed answers for: market size concerns, competitive threats, team gaps, unit economics, and path to profitability
   - Build appendix slides for deep-dive topics: detailed financials, cohort analysis, product roadmap
   - Address the "why hasn't this been done before" question proactively
   - Prepare the "what happens if you don't raise" answer to show resilience

5. INVESTOR-SPECIFIC TAILORING
   - Adapt the emphasis based on round: pre-seed (team + vision), seed (product + early traction), Series A (growth + unit economics)
   - Highlight metrics that matter most to [INVESTOR TYPE]: angels want story, VCs want data
   - Include social proof: advisors, customers, partners that signal credibility
   - Show you understand the investor's portfolio and why this fits their thesis
   - Name-drop early investors or commitments if any exist to create momentum

6. DELIVERY GUIDANCE
   - Write speaker notes for each slide with the key message and transition
   - Time each slide: spend 70% of time on Problem, Solution, Traction, and Ask
   - Design the email pitch that accompanies the deck (3-4 sentences that get the meeting)
   - Create the "forwardable" summary: a 2-sentence description investors share with partners
   - Prepare for the follow-up: what data room materials to have ready

Present the pitch as a complete slide-by-slide outline with content, speaker notes, and design direction. Include the email pitch template and a checklist of materials to prepare before approaching investors.

Be specific to my situation. No generic filler.
